/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.plugin.compiler.ModuleInfoPatchException;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;

final class ModuleInfoPatch {
    public static final String FILENAME = "module-info-patch.maven";
    private static final String TEST_MODULE_PATH = "TEST-MODULE-PATH";
    private static final String SUBPROJECT_MODULES = "SUBPROJECT-MODULES";
    private static final Set<String> ADD_MODULES_SPECIAL_CASES = Set.of("ALL-MODULE-PATH", "TEST-MODULE-PATH");
    private static final Set<String> ADD_EXPORTS_SPECIAL_CASES = Set.of("ALL-UNNAMED", "TEST-MODULE-PATH", "SUBPROJECT-MODULES");
    private String moduleName;
    private final Set<String> addModules;
    private final Set<String> limitModules;
    private final Set<String> addReads;
    private final Map<String, Set<String>> addExports;
    private final Map<String, Set<String>> addOpens;
    private ModuleInfoPatch runtimeDependencies;
    private static final int COMPILE = 1;
    private static final int RUNTIME = 2;

    ModuleInfoPatch(String defaultModule, ModuleInfoPatch previous) {
        if (defaultModule != null && !defaultModule.isBlank()) {
            this.moduleName = defaultModule;
        }
        if (previous != null) {
            this.addModules = previous.addModules;
            this.limitModules = previous.limitModules;
        } else {
            this.addModules = new LinkedHashSet<String>();
            this.limitModules = new LinkedHashSet<String>();
        }
        this.addReads = new LinkedHashSet<String>();
        this.addExports = new LinkedHashMap<String, Set<String>>();
        this.addOpens = new LinkedHashMap<String, Set<String>>();
        this.runtimeDependencies = this;
    }

    private ModuleInfoPatch(ModuleInfoPatch parent) {
        this.moduleName = parent.moduleName;
        this.addModules = new LinkedHashSet<String>(parent.addModules);
        this.limitModules = new LinkedHashSet<String>(parent.limitModules);
        this.addReads = new LinkedHashSet<String>(parent.addReads);
        this.addExports = new LinkedHashMap<String, Set<String>>(parent.addExports);
        this.addOpens = new LinkedHashMap<String, Set<String>>(parent.addOpens);
    }

    private ModuleInfoPatch(Set<String> addReads, String moduleName) {
        this.moduleName = moduleName;
        this.addReads = addReads;
        this.addModules = Collections.emptySet();
        this.limitModules = Collections.emptySet();
        this.addExports = Collections.emptyMap();
        this.addOpens = Collections.emptyMap();
    }

    public void setToDefaults() {
        this.addModules.add(TEST_MODULE_PATH);
        this.addReads.add(TEST_MODULE_PATH);
    }

    public void load(Reader source) throws IOException {
        StreamTokenizer reader = new StreamTokenizer(source);
        reader.slashSlashComments(true);
        reader.slashStarComments(true);
        ModuleInfoPatch.expectToken(reader, "patch-module");
        this.moduleName = ModuleInfoPatch.nextName(reader, true);
        ModuleInfoPatch.expectToken(reader, '{');
        block14: while (reader.nextToken() == -3) {
            switch (reader.sval) {
                case "add-modules": {
                    ModuleInfoPatch.readModuleList(reader, this.addModules, ADD_MODULES_SPECIAL_CASES);
                    continue block14;
                }
                case "limit-modules": {
                    ModuleInfoPatch.readModuleList(reader, this.limitModules, Set.of());
                    continue block14;
                }
                case "add-reads": {
                    ModuleInfoPatch.readModuleList(reader, this.addReads, Set.of(TEST_MODULE_PATH));
                    continue block14;
                }
                case "add-exports": {
                    ModuleInfoPatch.readQualified(reader, this.addExports, ADD_EXPORTS_SPECIAL_CASES);
                    continue block14;
                }
                case "add-opens": {
                    ModuleInfoPatch.readQualified(reader, this.addOpens, Set.of());
                    continue block14;
                }
            }
            throw new ModuleInfoPatchException("Unknown keyword \"" + reader.sval + "\"", reader);
        }
        if (reader.ttype != 125) {
            throw new ModuleInfoPatchException("Not a token", reader);
        }
        if (reader.nextToken() != -1) {
            throw new ModuleInfoPatchException("Expected end of file but found \"" + reader.sval + "\"", reader);
        }
    }

    private static void expectToken(StreamTokenizer reader, String expected) throws IOException {
        if (reader.nextToken() != -3 || !expected.equals(reader.sval)) {
            throw new ModuleInfoPatchException("Expected \"" + expected + "\"", reader);
        }
    }

    private static void expectToken(StreamTokenizer reader, char expected) throws IOException {
        if (reader.nextToken() != expected) {
            throw new ModuleInfoPatchException("Expected \"" + expected + "\"", reader);
        }
    }

    private static String nextName(StreamTokenizer reader, boolean module) throws IOException {
        if (reader.nextToken() != -3) {
            throw new ModuleInfoPatchException("Expected a " + (module ? "module" : "package") + " name", reader);
        }
        return ModuleInfoPatch.ensureValidName(reader, reader.sval.strip(), module);
    }

    private static String ensureValidName(StreamTokenizer reader, String name, boolean module) {
        int c;
        int length = name.length();
        boolean expectFirstChar = true;
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = name.codePointAt(i);
            if (expectFirstChar) {
                if (!Character.isJavaIdentifierStart(c)) break;
                expectFirstChar = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            expectFirstChar = true;
            if (c != 46) break;
        }
        if (expectFirstChar) {
            throw new ModuleInfoPatchException("Invalid " + (module ? "module" : "package") + " name \"" + name + "\"", reader);
        }
        return name;
    }

    private static void readModuleList(StreamTokenizer reader, Set<String> target, Set<String> specialCases) throws IOException {
        while (true) {
            if (reader.nextToken() == -3) {
                String module = reader.sval.strip();
                if (!specialCases.contains(module)) {
                    module = ModuleInfoPatch.ensureValidName(reader, module, true);
                }
                target.add(module);
                continue;
            }
            if (reader.ttype != 44) break;
        }
        if (reader.ttype != 59) {
            throw new ModuleInfoPatchException("Missing ';' character", reader);
        }
    }

    private static void readQualified(StreamTokenizer reader, Map<String, Set<String>> target, Set<String> specialCases) throws IOException {
        String packageName = ModuleInfoPatch.nextName(reader, false);
        ModuleInfoPatch.expectToken(reader, "to");
        ModuleInfoPatch.readModuleList(reader, ModuleInfoPatch.modulesForPackage(target, packageName), specialCases);
    }

    private static Set<String> modulesForPackage(Map<String, Set<String>> target, String packageName) {
        return target.computeIfAbsent(packageName, key -> new LinkedHashSet());
    }

    private static boolean addModuleName(Set<String> compile, Set<String> runtime, int scope, String module) {
        boolean modified = false;
        if ((scope & 1) != 0) {
            modified = compile.add(module);
        }
        if ((scope & 2) != 0 && compile != runtime) {
            modified |= runtime.add(module);
        }
        return modified;
    }

    private boolean addExport(String packageName, int scope, String module) {
        Set<String> compile;
        Set<String> runtime = compile = ModuleInfoPatch.modulesForPackage(this.addExports, packageName);
        if (this.runtimeDependencies != this) {
            runtime = ModuleInfoPatch.modulesForPackage(this.runtimeDependencies.addExports, packageName);
        }
        return ModuleInfoPatch.addModuleName(compile, runtime, scope, module);
    }

    public void replaceProjectModules(List<SourceDirectory> sourceDirectories) {
        for (Map.Entry<String, Set<String>> entry : this.addExports.entrySet()) {
            if (!entry.getValue().remove(SUBPROJECT_MODULES)) continue;
            for (SourceDirectory source : sourceDirectories) {
                String module = source.moduleName;
                if (module == null || module.equals(this.moduleName)) continue;
                this.addExport(entry.getKey(), 3, module);
            }
        }
    }

    public void replaceTestModulePath(DependencyResolverResult dependencyResolution) throws IOException {
        LinkedHashSet<String> exportsToTestModulePath = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.addExports.entrySet()) {
            if (!entry.getValue().remove(TEST_MODULE_PATH)) continue;
            exportsToTestModulePath.add(entry.getKey());
        }
        boolean addAllTestModulePath = this.addModules.remove(TEST_MODULE_PATH);
        boolean readAllTestModulePath = this.addReads.remove(TEST_MODULE_PATH);
        if (!addAllTestModulePath && !readAllTestModulePath && exportsToTestModulePath.isEmpty()) {
            return;
        }
        if (dependencyResolution == null) {
            return;
        }
        HashMap<String, Integer> done = new HashMap<String, Integer>();
        block6: for (Map.Entry entry : dependencyResolution.getDependencies().entrySet()) {
            int scope;
            switch (((Dependency)entry.getKey()).getScope()) {
                case TEST: {
                    scope = 3;
                    break;
                }
                case TEST_ONLY: {
                    scope = 1;
                    if (this.runtimeDependencies != this) break;
                    this.runtimeDependencies = new ModuleInfoPatch(this);
                    break;
                }
                case TEST_RUNTIME: {
                    scope = 2;
                    if (this.runtimeDependencies != this) break;
                    this.runtimeDependencies = new ModuleInfoPatch(this);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            Path dependencyPath = (Path)entry.getValue();
            String module = dependencyResolution.getModuleName(dependencyPath).orElse(null);
            if (module == null) {
                if (!readAllTestModulePath) continue;
                ModuleInfoPatch.addModuleName(this.addReads, this.runtimeDependencies.addReads, scope, "ALL-UNNAMED");
                continue;
            }
            if (!ModuleInfoPatch.mergeBit(done, module, scope)) continue;
            boolean modified = false;
            if (addAllTestModulePath) {
                modified |= ModuleInfoPatch.addModuleName(this.addModules, this.runtimeDependencies.addModules, scope, module);
            }
            if (readAllTestModulePath) {
                modified |= ModuleInfoPatch.addModuleName(this.addReads, this.runtimeDependencies.addReads, scope, module);
            }
            for (String packageName : exportsToTestModulePath) {
                modified |= this.addExport(packageName, scope, module);
            }
            if (!modified) continue;
            dependencyResolution.getModuleDescriptor(dependencyPath).ifPresent(descriptor -> {
                for (ModuleDescriptor.Requires r : descriptor.requires()) {
                    done.merge(r.name(), scope, (o, n) -> o | n);
                }
            });
        }
    }

    private static boolean mergeBit(Map<String, Integer> map, String key, int bit) {
        Integer mask = map.putIfAbsent(key, bit);
        if (mask != null) {
            if ((mask & bit) != 0) {
                return false;
            }
            map.put(key, mask | bit);
        }
        return true;
    }

    public ModuleInfoPatch patchWithSameReads(String otherModule) {
        if (otherModule == null || otherModule.isBlank()) {
            return null;
        }
        ModuleInfoPatch other = new ModuleInfoPatch(this.addReads, otherModule);
        other.runtimeDependencies = this.runtimeDependencies == this ? other : new ModuleInfoPatch(this.runtimeDependencies.addReads, otherModule);
        return other;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    private static void write(String option, String prefix, Set<String> compile, Set<String> runtime, Options configuration, BufferedWriter out) throws IOException {
        Set<String> values = runtime;
        do {
            if (values.isEmpty()) continue;
            StringJoiner buffer = new StringJoiner(",", (CharSequence)(prefix != null ? prefix + "=" : ""), "");
            for (String value : values) {
                buffer.add(value);
            }
            if (values == compile) {
                configuration.addIfNonBlank("--" + option, buffer.toString());
            }
            if (values != runtime) continue;
            out.append("--").append(option).append(' ').append(buffer.toString());
            out.newLine();
        } while (values != compile && (values = compile) != null);
    }

    private void write(String option, Map<String, Set<String>> compile, Map<String, Set<String>> runtime, Options configuration, BufferedWriter out) throws IOException {
        Map<String, Set<String>> values = runtime;
        do {
            for (Map.Entry<String, Set<String>> entry : values.entrySet()) {
                String prefix = this.moduleName + "/" + entry.getKey();
                Set<String> otherModules = entry.getValue();
                ModuleInfoPatch.write(option, prefix, values == compile ? otherModules : null, values == runtime ? otherModules : Set.of(), configuration, out);
            }
        } while (values != compile && (values = compile) != null);
    }

    public void writeTo(Options compile, BufferedWriter runtime) throws IOException {
        ModuleInfoPatch.write("add-modules", null, this.addModules, this.runtimeDependencies.addModules, compile, runtime);
        ModuleInfoPatch.write("limit-modules", null, this.limitModules, this.runtimeDependencies.limitModules, compile, runtime);
        if (this.moduleName != null) {
            ModuleInfoPatch.write("add-reads", this.moduleName, this.addReads, this.runtimeDependencies.addReads, compile, runtime);
            this.write("add-exports", this.addExports, this.runtimeDependencies.addExports, compile, runtime);
            this.write("add-opens", null, this.runtimeDependencies.addOpens, compile, runtime);
        }
        this.addModules.clear();
        this.limitModules.clear();
    }
}

