/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.checkstyle.CheckstyleReportGenerator;
import org.apache.maven.plugins.checkstyle.ReportResource;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutor;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorException;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleResults;
import org.apache.maven.plugins.checkstyle.rss.CheckstyleRssGenerator;
import org.apache.maven.plugins.checkstyle.rss.CheckstyleRssGeneratorRequest;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCheckstyleReport
extends AbstractMavenReport {
    public static final String PLUGIN_RESOURCES = "org/apache/maven/plugins/checkstyle";
    protected static final String JAVA_FILES = "**\\/*.java";
    private static final String DEFAULT_CONFIG_LOCATION = "sun_checks.xml";
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    protected String cacheFile;
    @Parameter(property="checkstyle.config.location", defaultValue="sun_checks.xml")
    protected String configLocation;
    @Parameter(property="checkstyle.consoleOutput", defaultValue="false")
    protected boolean consoleOutput;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="false")
    protected boolean failsOnError;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    protected String headerLocation;
    @Parameter(property="checkstyle.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="checkstyle.output.file", defaultValue="${project.build.directory}/checkstyle-result.xml")
    private File outputFile;
    @Parameter(property="checkstyle.properties.location")
    protected String propertiesLocation;
    @Parameter
    protected String propertyExpansion;
    @Parameter(defaultValue="${project.resources}", readonly=true)
    protected List<Resource> resources;
    @Parameter(defaultValue="${project.testResources}", readonly=true)
    protected List<Resource> testResources;
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    protected String includes;
    @Parameter(property="checkstyle.excludes")
    protected String excludes;
    @Parameter(property="checkstyle.resourceIncludes", defaultValue="**/*.properties", required=true)
    protected String resourceIncludes;
    @Parameter(property="checkstyle.resourceExcludes")
    protected String resourceExcludes;
    @Parameter(property="checkstyle.includeResources", defaultValue="true", required=true)
    protected boolean includeResources;
    @Parameter(property="checkstyle.includeTestResources", defaultValue="true", required=true)
    protected boolean includeTestResources;
    @Deprecated
    @Parameter
    private File sourceDirectory;
    @Parameter
    private List<String> sourceDirectories;
    @Deprecated
    @Parameter
    private File testSourceDirectory;
    @Parameter
    private List<String> testSourceDirectories;
    @Parameter(defaultValue="false")
    protected boolean includeTestSourceDirectory;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    protected String suppressionsFileExpression;
    @Parameter(property="checkstyle.suppressions.location")
    protected String suppressionsLocation;
    @Parameter
    private File useFile;
    @Parameter(property="checkstyle.output.format", defaultValue="xml")
    private String outputFileFormat;
    @Parameter(property="checkstyle.enable.rules.summary", defaultValue="true")
    private boolean enableRulesSummary;
    @Parameter(property="checkstyle.enable.severity.summary", defaultValue="true")
    private boolean enableSeveritySummary;
    @Parameter(property="checkstyle.enable.files.summary", defaultValue="true")
    private boolean enableFilesSummary;
    @Parameter(property="checkstyle.enable.rss", defaultValue="true")
    private boolean enableRSS;
    @Component(role=SiteTool.class)
    protected SiteTool siteTool;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor plugin;
    @Parameter(property="linkXRef", defaultValue="true")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private File xrefLocation;
    @Parameter
    private List<String> treeWalkerNames;
    @Parameter(defaultValue="false")
    private boolean omitIgnoredModules;
    @Parameter
    private PlexusConfiguration checkstyleRules;
    @Parameter(property="checkstyle.output.rules.file", defaultValue="${project.build.directory}/checkstyle-rules.xml")
    private File rulesFiles;
    @Parameter(defaultValue="<?xml version=\"1.0\"?>\n<!DOCTYPE module PUBLIC \"-//Checkstyle//DTD Checkstyle Configuration 1.3//EN\"\n        \"https://checkstyle.org/dtds/configuration_1_3.dtd\">\n")
    private String checkstyleRulesHeader;
    @Component
    protected ResourceManager locator;
    @Component(role=CheckstyleRssGenerator.class, hint="default")
    protected CheckstyleRssGenerator checkstyleRssGenerator;
    @Component(role=CheckstyleExecutor.class, hint="default")
    protected CheckstyleExecutor checkstyleExecutor;
    protected ByteArrayOutputStream stringOutputStream;

    public String getName(Locale locale) {
        return AbstractCheckstyleReport.getBundle(locale).getString("report.checkstyle.name");
    }

    public String getDescription(Locale locale) {
        return AbstractCheckstyleReport.getBundle(locale).getString("report.checkstyle.description");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        this.checkDeprecatedParameterUsage(this.sourceDirectory, "sourceDirectory", "sourceDirectories");
        this.checkDeprecatedParameterUsage(this.testSourceDirectory, "testSourceDirectory", "testSourceDirectories");
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        if (this.checkstyleRules != null) {
            if (!DEFAULT_CONFIG_LOCATION.equals(this.configLocation)) {
                throw new MavenReportException("If you use inline configuration for rules, don't specify a configLocation");
            }
            if (this.checkstyleRules.getChildCount() > 1) {
                throw new MavenReportException("Currently only one root module is supported");
            }
            PlexusConfiguration checkerModule = this.checkstyleRules.getChild(0);
            try {
                FileUtils.forceMkdir((File)this.rulesFiles.getParentFile());
                FileUtils.fileWrite((File)this.rulesFiles, (String)(this.checkstyleRulesHeader + checkerModule.toString()));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
            this.configLocation = this.rulesFiles.getAbsolutePath();
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            CheckstyleExecutorRequest request = this.createRequest().setLicenseArtifacts(this.collectArtifacts("license")).setConfigurationArtifacts(this.collectArtifacts("configuration")).setOmitIgnoredModules(this.omitIgnoredModules);
            CheckstyleResults results = this.checkstyleExecutor.executeCheckstyle(request);
            ResourceBundle bundle = AbstractCheckstyleReport.getBundle(locale);
            this.generateReportStatics();
            this.generateMainReport(results, bundle);
            if (this.enableRSS) {
                CheckstyleRssGeneratorRequest checkstyleRssGeneratorRequest = new CheckstyleRssGeneratorRequest(this.project, this.getCopyright(), this.outputDirectory, this.getLog());
                this.checkstyleRssGenerator.generateRSS(results, checkstyleRssGeneratorRequest);
            }
        }
        catch (CheckstyleException e) {
            throw new MavenReportException("Failed during checkstyle configuration", (Exception)((Object)e));
        }
        catch (CheckstyleExecutorException e) {
            throw new MavenReportException("Failed during checkstyle execution", (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void checkDeprecatedParameterUsage(Object parameter, String name, String replacement) throws MavenReportException {
        if (parameter != null) {
            throw new MavenReportException("You are using '" + name + "' which has been removed from the maven-checkstyle-plugin. Please use '" + replacement + "' and refer to the >>Major Version Upgrade to version 3.0.0<< on the plugin site.");
        }
    }

    protected abstract CheckstyleExecutorRequest createRequest() throws MavenReportException;

    private List<Artifact> collectArtifacts(String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        PluginManagement pluginManagement = this.project.getBuild().getPluginManagement();
        if (pluginManagement != null) {
            artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(pluginManagement.getPluginsAsMap(), hint));
        }
        artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(this.project.getBuild().getPluginsAsMap(), hint));
        return artifacts;
    }

    private List<Artifact> getCheckstylePluginDependenciesAsArtifacts(Map<String, Plugin> plugins, String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Plugin checkstylePlugin = plugins.get(this.plugin.getGroupId() + ":" + this.plugin.getArtifactId());
        if (checkstylePlugin != null) {
            for (Dependency dep : checkstylePlugin.getDependencies()) {
                String depKey = dep.getGroupId() + ":" + dep.getArtifactId();
                artifacts.add((Artifact)this.plugin.getArtifactMap().get(depKey));
            }
        }
        return artifacts;
    }

    protected AuditListener getListener() throws MavenReportException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, AutomaticBean.OutputStreamOptions.CLOSE);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, AutomaticBean.OutputStreamOptions.CLOSE);
            } else {
                throw new MavenReportException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private OutputStream getOutputStream(File file) throws MavenReportException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    protected DefaultLogger getConsoleListener() throws MavenReportException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, AutomaticBean.OutputStreamOptions.NONE);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, AutomaticBean.OutputStreamOptions.CLOSE);
        }
        return consoleListener;
    }

    private void generateReportStatics() throws MavenReportException {
        ReportResource rresource = new ReportResource(PLUGIN_RESOURCES, this.outputDirectory);
        try {
            rresource.copy("images/rss.png");
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.", (Exception)e);
        }
    }

    private String getCopyright() {
        int currentYear = Calendar.getInstance().get(1);
        String copyright = StringUtils.isNotEmpty((String)this.project.getInceptionYear()) && !String.valueOf(currentYear).equals(this.project.getInceptionYear()) ? this.project.getInceptionYear() + " - " + currentYear : String.valueOf(currentYear);
        if (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName())) {
            copyright = copyright + " " + this.project.getOrganization().getName();
        }
        return copyright;
    }

    private void generateMainReport(CheckstyleResults results, ResourceBundle bundle) {
        CheckstyleReportGenerator generator = new CheckstyleReportGenerator(this.getSink(), bundle, this.project.getBasedir(), this.siteTool, this.configLocation);
        generator.setLog(this.getLog());
        generator.setEnableRulesSummary(this.enableRulesSummary);
        generator.setEnableSeveritySummary(this.enableSeveritySummary);
        generator.setEnableFilesSummary(this.enableFilesSummary);
        generator.setEnableRSS(this.enableRSS);
        generator.setCheckstyleConfig(results.getConfiguration());
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                generator.setXrefLocation(relativePath);
            } else {
                for (ReportPlugin report : this.getProject().getReportPlugins()) {
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    generator.setXrefLocation(relativePath);
                }
            }
            if (generator.getXrefLocation() == null && results.getFileCount() > 0) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        if (this.treeWalkerNames != null) {
            generator.setTreeWalkerNames(this.treeWalkerNames);
        }
        generator.generateReport(results);
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("checkstyle-report", locale, AbstractCheckstyleReport.class.getClassLoader());
    }

    protected List<File> getSourceDirectories() {
        if (this.sourceDirectories == null) {
            this.sourceDirectories = this.project.getCompileSourceRoots();
        }
        ArrayList<File> sourceDirs = new ArrayList<File>(this.sourceDirectories.size());
        for (String sourceDir : this.sourceDirectories) {
            sourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)sourceDir));
        }
        return sourceDirs;
    }

    protected List<File> getTestSourceDirectories() {
        if (this.testSourceDirectories == null) {
            this.testSourceDirectories = this.project.getTestCompileSourceRoots();
        }
        ArrayList<File> testSourceDirs = new ArrayList<File>(this.testSourceDirectories.size());
        for (String testSourceDir : this.testSourceDirectories) {
            testSourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)testSourceDir));
        }
        return testSourceDirs;
    }
}

