/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.io.File;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

public final class AssemblyFileUtils {
    private AssemblyFileUtils() {
    }

    public static String makePathRelativeTo(String path, File basedir) {
        String base;
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).startsWith(base = basedir.getAbsolutePath())) {
            if ((path = path.substring(base.length())).length() > 0 && (path.startsWith("/") || path.startsWith("\\"))) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                path = ".";
            }
        }
        if (!new File(path).isAbsolute()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static void verifyTempDirectoryAvailability(@Nonnull File tempDir) {
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    @Nonnull
    private static String normalizePath(@Nonnull String path) {
        return path.replace('\\', '/');
    }

    @Nonnull
    public static String normalizeFileInfo(@Nonnull FileInfo fileInfo) {
        String name = fileInfo.getName();
        name = AssemblyFileUtils.normalizePath(name);
        return name.replace(File.separatorChar, '/');
    }

    public static boolean isPropertyFile(String sourceName) {
        return sourceName.toLowerCase(Locale.ENGLISH).endsWith(".properties");
    }

    public static boolean isPropertyFile(File file) {
        return AssemblyFileUtils.isPropertyFile(file.getName());
    }
}

