/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Site
implements Serializable,
InputLocationTracker {
    final String id;
    final String name;
    final String url;
    final String childSiteUrlInheritAppendPath;
    final Map<Object, InputLocation> locations;

    Site(String id, String name, String url, String childSiteUrlInheritAppendPath, Map<Object, InputLocation> locations) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChildSiteUrlInheritAppendPath() {
        return this.childSiteUrlInheritAppendPath;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Site.newBuilder(this);
    }

    @Nonnull
    public Site withId(String id) {
        return Site.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Site withName(String name) {
        return Site.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Site withUrl(String url) {
        return Site.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Site withChildSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
        return Site.newBuilder(this, true).childSiteUrlInheritAppendPath(childSiteUrlInheritAppendPath).build();
    }

    @Nonnull
    public static Site newInstance() {
        return Site.newInstance(true);
    }

    @Nonnull
    public static Site newInstance(boolean withDefaults) {
        return Site.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Site.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Site from) {
        return Site.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Site from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isChildSiteUrlInheritAppendPath() {
        return this.getChildSiteUrlInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildSiteUrlInheritAppendPath()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        Site base;
        String id;
        String name;
        String url;
        String childSiteUrlInheritAppendPath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Site base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.childSiteUrlInheritAppendPath = base.childSiteUrlInheritAppendPath;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
            this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Site build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.childSiteUrlInheritAppendPath != null && this.childSiteUrlInheritAppendPath != this.base.childSiteUrlInheritAppendPath)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            locations.put("childSiteUrlInheritAppendPath", newlocs.containsKey("childSiteUrlInheritAppendPath") ? (InputLocation)newlocs.get("childSiteUrlInheritAppendPath") : (InputLocation)oldlocs.get("childSiteUrlInheritAppendPath"));
            return new Site(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.childSiteUrlInheritAppendPath != null ? this.childSiteUrlInheritAppendPath : (this.base != null ? this.base.childSiteUrlInheritAppendPath : null), locations);
        }
    }
}

