/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.api.ContextualFixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

class KStreamFilter<K, V>
implements FixedKeyProcessorSupplier<K, V, V> {
    private final Predicate<K, V> predicate;
    private final boolean filterNot;

    public KStreamFilter(Predicate<K, V> predicate, boolean filterNot) {
        this.predicate = predicate;
        this.filterNot = filterNot;
    }

    @Override
    public FixedKeyProcessor<K, V, V> get() {
        return new KStreamFilterProcessor();
    }

    private class KStreamFilterProcessor
    extends ContextualFixedKeyProcessor<K, V, V> {
        private KStreamFilterProcessor() {
        }

        @Override
        public void process(FixedKeyRecord<K, V> record) {
            if (KStreamFilter.this.filterNot ^ KStreamFilter.this.predicate.test(record.key(), record.value())) {
                this.context().forward(record);
            }
        }
    }
}

