/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGrouper {
    private static final Logger log = LoggerFactory.getLogger(PartitionGrouper.class);

    public Map<TaskId, Set<TopicPartition>> partitionGroups(Map<TopologyMetadata.Subtopology, Set<String>> topicGroups, Cluster metadata) {
        HashMap groups = new HashMap();
        for (Map.Entry<TopologyMetadata.Subtopology, Set<String>> entry : topicGroups.entrySet()) {
            TopologyMetadata.Subtopology subtopology = entry.getKey();
            Set<String> topicGroup = entry.getValue();
            int maxNumPartitions = this.maxNumPartitions(metadata, topicGroup);
            for (int partitionId = 0; partitionId < maxNumPartitions; ++partitionId) {
                HashSet<TopicPartition> group = new HashSet<TopicPartition>(topicGroup.size());
                for (String topic : topicGroup) {
                    List partitions = metadata.partitionsForTopic(topic);
                    if (partitionId >= partitions.size()) continue;
                    group.add(new TopicPartition(topic, partitionId));
                }
                groups.put(new TaskId(subtopology.nodeGroupId, partitionId, subtopology.namedTopology), Collections.unmodifiableSet(group));
            }
        }
        return Collections.unmodifiableMap(groups);
    }

    protected int maxNumPartitions(Cluster metadata, Set<String> topics) {
        int maxNumPartitions = 0;
        for (String topic : topics) {
            List partitions = metadata.partitionsForTopic(topic);
            if (partitions.isEmpty()) {
                log.error("Empty partitions for topic {}", (Object)topic);
                throw new RuntimeException("Empty partitions for topic " + topic);
            }
            int numPartitions = partitions.size();
            if (numPartitions <= maxNumPartitions) continue;
            maxNumPartitions = numPartitions;
        }
        return maxNumPartitions;
    }
}

