/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.internals.PrintForeachAction;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

public class KStreamPrint<K, V>
implements ProcessorSupplier<K, V, Void, Void> {
    private final ForeachAction<K, V> action;

    public KStreamPrint(ForeachAction<K, V> action) {
        this.action = action;
    }

    @Override
    public Processor<K, V, Void, Void> get() {
        return new KStreamPrintProcessor();
    }

    private class KStreamPrintProcessor
    implements Processor<K, V, Void, Void> {
        private KStreamPrintProcessor() {
        }

        @Override
        public void process(Record<K, V> record) {
            KStreamPrint.this.action.apply(record.key(), record.value());
        }

        @Override
        public void close() {
            if (KStreamPrint.this.action instanceof PrintForeachAction) {
                ((PrintForeachAction)KStreamPrint.this.action).close();
            }
        }
    }
}

