/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.server.util.Json;
import org.apache.kafka.server.util.json.DecodeJson;
import org.apache.kafka.server.util.json.JsonObject;
import org.apache.kafka.server.util.json.JsonValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonTest {
    private static final String JSON = "{\n  \"boolean\": false,\n  \"int\": 1234,\n  \"long\": 3000000000,\n  \"double\": 16.244355,\n  \"string\": \"string\",\n  \"number_as_string\": \"123\",\n  \"array\": [4.0, 11.1, 44.5],\n  \"object\": {\n    \"a\": true,\n    \"b\": false\n  },\n  \"null\": null\n}";

    private JsonValue parse(String s) {
        return (JsonValue)Json.parseFull((String)s).orElseThrow(() -> new RuntimeException("Failed to parse json: " + s));
    }

    @Test
    public void testAsJsonObject() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assertions.assertEquals((Object)obj, (Object)obj.asJsonObject());
        Assertions.assertThrows(JsonMappingException.class, () -> parsed.apply("array").asJsonObject());
    }

    @Test
    public void testAsJsonObjectOption() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        Assertions.assertTrue((boolean)parsed.apply("object").asJsonObjectOptional().isPresent());
        Assertions.assertEquals(Optional.empty(), (Object)parsed.apply("array").asJsonObjectOptional());
    }

    @Test
    public void testAsJsonArray() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assertions.assertEquals((Object)array, (Object)array.asJsonArray());
        Assertions.assertThrows(JsonMappingException.class, () -> parsed.apply("object").asJsonArray());
    }

    @Test
    public void testAsJsonArrayOption() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        Assertions.assertTrue((boolean)parsed.apply("array").asJsonArrayOptional().isPresent());
        Assertions.assertEquals(Optional.empty(), (Object)parsed.apply("object").asJsonArrayOptional());
    }

    @Test
    public void testJsonObjectGet() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        Assertions.assertEquals(Optional.of(this.parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assertions.assertEquals(Optional.empty(), (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() throws JsonProcessingException {
        JsonObject parsed = this.parse(JSON).asJsonObject();
        Assertions.assertEquals((Object)this.parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        Assertions.assertThrows(JsonMappingException.class, () -> parsed.apply("aaaaaaaa"));
    }

    @Test
    public void testJsonArrayIterator() throws JsonProcessingException {
        ArrayList results = new ArrayList();
        this.parse(JSON).asJsonObject().apply("array").asJsonArray().iterator().forEachRemaining(results::add);
        List expected = Stream.of("4.0", "11.1", "44.5").map(this::parse).collect(Collectors.toList());
        Assertions.assertEquals(expected, results);
    }

    @Test
    public void testJsonValueEquals() {
        Assertions.assertEquals((Object)this.parse(JSON), (Object)this.parse(JSON));
        Assertions.assertEquals((Object)this.parse("{\"blue\": true, \"red\": false}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assertions.assertNotEquals((Object)this.parse("{\"blue\": true, \"red\": true}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assertions.assertEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[1, 2, 3]"));
        Assertions.assertNotEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[2, 1, 3]"));
        Assertions.assertEquals((Object)this.parse("1344"), (Object)this.parse("1344"));
        Assertions.assertNotEquals((Object)this.parse("1344"), (Object)this.parse("144"));
    }

    @Test
    public void testJsonValueHashCode() throws JsonProcessingException {
        Assertions.assertEquals((int)new ObjectMapper().readTree(JSON).hashCode(), (int)this.parse(JSON).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assertions.assertEquals((Object)js, (Object)this.parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() throws JsonMappingException {
        DecodeJson.DecodeBoolean decodeJson = new DecodeJson.DecodeBoolean();
        this.assertTo(false, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("boolean").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
    }

    @Test
    public void testDecodeString() throws JsonMappingException {
        DecodeJson.DecodeString decodeJson = new DecodeJson.DecodeString();
        this.assertTo((Object)"string", (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("string").get());
        this.assertTo((Object)"123", (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("number_as_string").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("array").get());
    }

    @Test
    public void testDecodeInt() throws JsonMappingException {
        DecodeJson.DecodeInteger decodeJson = new DecodeJson.DecodeInteger();
        this.assertTo(1234, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("long").get());
    }

    @Test
    public void testDecodeLong() throws JsonMappingException {
        DecodeJson.DecodeLong decodeJson = new DecodeJson.DecodeLong();
        this.assertTo(3000000000L, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("long").get());
        this.assertTo(1234L, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("string").get());
    }

    @Test
    public void testDecodeDouble() throws JsonMappingException {
        DecodeJson.DecodeDouble decodeJson = new DecodeJson.DecodeDouble();
        this.assertTo(16.244355, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("double").get());
        this.assertTo(1234.0, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
        this.assertTo(3.0E9, (DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("long").get());
        this.assertToFails((DecodeJson)decodeJson, jsonObject -> (JsonValue)jsonObject.get("string").get());
    }

    @Test
    public void testDecodeSeq() throws JsonMappingException {
        DecodeJson decodeJson = DecodeJson.decodeList((DecodeJson)new DecodeJson.DecodeDouble());
        this.assertTo(List.of(Double.valueOf(4.0), Double.valueOf(11.1), Double.valueOf(44.5)), decodeJson, jsonObject -> (JsonValue)jsonObject.get("array").get());
        this.assertToFails(decodeJson, jsonObject -> (JsonValue)jsonObject.get("string").get());
        this.assertToFails(decodeJson, jsonObject -> (JsonValue)jsonObject.get("object").get());
        this.assertToFails(DecodeJson.decodeList((DecodeJson)new DecodeJson.DecodeString()), jsonObject -> (JsonValue)jsonObject.get("array").get());
    }

    @Test
    public void testDecodeMap() throws JsonMappingException {
        DecodeJson decodeJson = DecodeJson.decodeMap((DecodeJson)new DecodeJson.DecodeBoolean());
        HashMap<String, Boolean> stringBooleanMap = new HashMap<String, Boolean>();
        stringBooleanMap.put("a", true);
        stringBooleanMap.put("b", false);
        this.assertTo(stringBooleanMap, decodeJson, jsonObject -> (JsonValue)jsonObject.get("object").get());
        this.assertToFails(DecodeJson.decodeMap((DecodeJson)new DecodeJson.DecodeInteger()), jsonObject -> (JsonValue)jsonObject.get("object").get());
        this.assertToFails(DecodeJson.decodeMap((DecodeJson)new DecodeJson.DecodeString()), jsonObject -> (JsonValue)jsonObject.get("object").get());
        this.assertToFails(DecodeJson.decodeMap((DecodeJson)new DecodeJson.DecodeDouble()), jsonObject -> (JsonValue)jsonObject.get("array").get());
    }

    @Test
    public void testDecodeOptional() throws JsonMappingException {
        DecodeJson decodeJson = DecodeJson.decodeOptional((DecodeJson)new DecodeJson.DecodeInteger());
        this.assertTo(Optional.empty(), decodeJson, jsonObject -> (JsonValue)jsonObject.get("null").get());
        this.assertTo(Optional.of(1234), decodeJson, jsonObject -> (JsonValue)jsonObject.get("int").get());
        this.assertToFails(DecodeJson.decodeOptional((DecodeJson)new DecodeJson.DecodeString()), jsonObject -> (JsonValue)jsonObject.get("int").get());
    }

    private <T> void assertTo(T expected, DecodeJson<T> decodeJson, Function<JsonObject, JsonValue> jsonValue) throws JsonMappingException {
        JsonValue parsed = jsonValue.apply(this.parse(JSON).asJsonObject());
        Assertions.assertEquals(expected, (Object)parsed.to(decodeJson));
    }

    private <T> void assertToFails(DecodeJson<T> decoder, Function<JsonObject, JsonValue> jsonValue) throws JsonMappingException {
        JsonObject obj = this.parse(JSON).asJsonObject();
        JsonValue parsed = jsonValue.apply(obj);
        Assertions.assertThrows(JsonMappingException.class, () -> parsed.to(decoder));
    }
}

