/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.FileAssertionJwtTemplate;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAssertionJwtTemplateTest {
    @Test
    public void testBasicUsage() throws Exception {
        String expected = this.createTemplateJson(Map.of("typ", "JWT", "alg", "RS256"), Map.of("sub", "jdoe"));
        File tmpFile = TestUtils.tempFile(expected);
        try (FileAssertionJwtTemplate template = new FileAssertionJwtTemplate(tmpFile);){
            Map header = template.header();
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"JWT", header.get("typ"));
            Assertions.assertEquals((Object)"RS256", header.get("alg"));
            Map payload = template.payload();
            Assertions.assertNotNull((Object)payload);
            Assertions.assertEquals((Object)"jdoe", payload.get("sub"));
        }
    }

    @Test
    public void testHeaderOnly() throws Exception {
        String expected = this.toJson(Map.of("header", Map.of("typ", "JWT", "alg", "RS256")));
        File tmpFile = TestUtils.tempFile(expected);
        try (FileAssertionJwtTemplate template = new FileAssertionJwtTemplate(tmpFile);){
            Map header = template.header();
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"JWT", header.get("typ"));
            Assertions.assertEquals((Object)"RS256", header.get("alg"));
            Map payload = template.payload();
            Assertions.assertNotNull((Object)payload);
            Assertions.assertTrue((boolean)payload.isEmpty());
        }
    }

    @Test
    public void testPayloadOnly() throws Exception {
        String expected = this.toJson(Map.of("payload", Map.of("sub", "jdoe")));
        File tmpFile = TestUtils.tempFile(expected);
        try (FileAssertionJwtTemplate template = new FileAssertionJwtTemplate(tmpFile);){
            Map header = template.header();
            Assertions.assertNotNull((Object)header);
            Assertions.assertTrue((boolean)header.isEmpty());
            Map payload = template.payload();
            Assertions.assertNotNull((Object)payload);
            Assertions.assertEquals((Object)"jdoe", payload.get("sub"));
        }
    }

    @Test
    public void testMalformedFile() throws Exception {
        String expected = "{invalid-json}";
        File tmpFile = TestUtils.tempFile(expected);
        Assertions.assertThrows(KafkaException.class, () -> new FileAssertionJwtTemplate(tmpFile));
    }

    @Test
    public void testMalformedFormat() throws Exception {
        String expected = this.toJson(Map.of("header", List.of("foo", "bar", "baz")));
        File tmpFile = TestUtils.tempFile(expected);
        Assertions.assertThrows(KafkaException.class, () -> new FileAssertionJwtTemplate(tmpFile));
    }

    private String createTemplateJson(Map<String, Object> header, Map<String, Object> payload) {
        Map<String, Object> topLevel = Map.of("header", header, "payload", payload);
        return this.toJson(topLevel);
    }

    private String toJson(Map<String, Object> map) {
        ObjectMapper mapper = new ObjectMapper();
        return (String)Assertions.assertDoesNotThrow(() -> mapper.writeValueAsString((Object)map));
    }
}

