/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.DynamicAssertionJwtTemplate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DynamicAssertionJwtTemplateTest {
    private final MockTime time = new MockTime();

    @Test
    public void testBasicUsage() throws IOException {
        String algorithm = "somealg";
        int expiration = 1;
        int notBefore = 20;
        boolean includeJti = false;
        try (DynamicAssertionJwtTemplate template = new DynamicAssertionJwtTemplate((Time)this.time, algorithm, expiration, notBefore, includeJti);){
            Map header = template.header();
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"JWT", header.get("typ"));
            Assertions.assertEquals((Object)algorithm, header.get("alg"));
            long currSeconds = this.time.milliseconds() / 1000L;
            Map payload = template.payload();
            Assertions.assertNotNull((Object)payload);
            Assertions.assertEquals((Object)currSeconds, payload.get("iat"));
            Assertions.assertEquals((Object)(currSeconds + (long)expiration), payload.get("exp"));
            Assertions.assertEquals((Object)(currSeconds - (long)notBefore), payload.get("nbf"));
            Assertions.assertNull(payload.get("jti"));
        }
    }

    @Test
    public void testJtiUniqueness() throws IOException {
        ArrayList<String> jwtIds = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            try (DynamicAssertionJwtTemplate template = new DynamicAssertionJwtTemplate((Time)this.time, "RSA", 1, 2, true);){
                Map payload = template.payload();
                Assertions.assertNotNull((Object)payload);
                String jwtId = (String)payload.get("jti");
                jwtIds.add(jwtId);
                continue;
            }
        }
        ArrayList jwtIds2 = new ArrayList(new HashSet(jwtIds));
        Assertions.assertEquals((int)jwtIds.size(), (int)jwtIds2.size());
        jwtIds.sort(Comparator.naturalOrder());
        jwtIds2.sort(Comparator.naturalOrder());
        Assertions.assertEquals(jwtIds, jwtIds2);
    }
}

