/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.VerificationKeyResolverFactory;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class VerificationKeyResolverFactoryTest
extends OAuthBearerTest {
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    @Test
    public void testConfigureRefreshingFileVerificationKeyResolver() throws Exception {
        String file = TestUtils.tempFile("{}").toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, String> configs = Collections.singletonMap("sasl.oauthbearer.jwks.endpoint.url", file);
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, (String)"OAUTHBEARER", this.getJaasConfigEntries()), "The JSON JWKS content does not include the keys member");
    }

    @Test
    public void testConfigureRefreshingFileVerificationKeyResolverWithInvalidDirectory() {
        String file = new File("/tmp/this-directory-does-not-exist/foo.json").toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.jwks.endpoint.url", file);
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, (String)"OAUTHBEARER", this.getJaasConfigEntries()), "that doesn't exist");
    }

    @Test
    public void testSaslOauthbearerTokenEndpointUrlIsNotAllowed() throws Exception {
        String file = TestUtils.tempFile("{}").toURI().toString();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.jwks.endpoint.url", file);
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, (String)"OAUTHBEARER", this.getJaasConfigEntries()), "org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }
}

