/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JwtResponseParser;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JwtResponseParserTest
extends OAuthBearerTest {
    @Test
    public void testParseJwt() throws IOException {
        String expected = "abc";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", expected);
        JwtResponseParser responseParser = new JwtResponseParser();
        String actual = responseParser.parseJwt(mapper.writeValueAsString((Object)node));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseJwtEmptyAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", "");
        JwtResponseParser responseParser = new JwtResponseParser();
        Assertions.assertThrows(JwtRetrieverException.class, () -> responseParser.parseJwt(mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseJwtMissingAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("sub", "jdoe");
        JwtResponseParser responseParser = new JwtResponseParser();
        Assertions.assertThrows(JwtRetrieverException.class, () -> responseParser.parseJwt(mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseJwtInvalidJson() {
        JwtResponseParser responseParser = new JwtResponseParser();
        Assertions.assertThrows(JwtRetrieverException.class, () -> responseParser.parseJwt("not valid JSON"));
    }
}

