/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WriteTxnMarkersResponseTest {
    private static final long PRODUCER_ID_ONE = 1L;
    private static final long PRODUCER_ID_TWO = 2L;
    private static final TopicPartition TP_1 = new TopicPartition("topic", 1);
    private static final TopicPartition TP_2 = new TopicPartition("topic", 2);
    private static final Errors PID_ONE_ERROR = Errors.UNKNOWN_PRODUCER_ID;
    private static final Errors PID_TWO_ERROR = Errors.INVALID_PRODUCER_EPOCH;
    private static Map<Long, Map<TopicPartition, Errors>> errorMap;

    @BeforeEach
    public void setUp() {
        errorMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        errorMap.put(1L, Collections.singletonMap(TP_1, PID_ONE_ERROR));
        errorMap.put(2L, Collections.singletonMap(TP_2, PID_TWO_ERROR));
    }

    @Test
    public void testConstructor() {
        EnumMap<Errors, Integer> expectedErrorCounts = new EnumMap<Errors, Integer>(Errors.class);
        expectedErrorCounts.put(Errors.UNKNOWN_PRODUCER_ID, 1);
        expectedErrorCounts.put(Errors.INVALID_PRODUCER_EPOCH, 1);
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(errorMap);
        Assertions.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
        Assertions.assertEquals(Collections.singletonMap(TP_1, PID_ONE_ERROR), response.errorsByProducerId().get(1L));
        Assertions.assertEquals(Collections.singletonMap(TP_2, PID_TWO_ERROR), response.errorsByProducerId().get(2L));
    }
}

