/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerGroupDescribeRequestTest {
    @Test
    void testGetErrorResponse() {
        List<String> groupIds = Arrays.asList("group0", "group1");
        ConsumerGroupDescribeRequestData data = new ConsumerGroupDescribeRequestData();
        data.groupIds().addAll(groupIds);
        ConsumerGroupDescribeRequest request = (ConsumerGroupDescribeRequest)new ConsumerGroupDescribeRequest.Builder(data, true).build();
        ApiException e = Errors.GROUP_AUTHORIZATION_FAILED.exception();
        int throttleTimeMs = 1000;
        ConsumerGroupDescribeResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)e);
        Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        for (int i = 0; i < groupIds.size(); ++i) {
            ConsumerGroupDescribeResponseData.DescribedGroup group = (ConsumerGroupDescribeResponseData.DescribedGroup)response.data().groups().get(i);
            Assertions.assertEquals((Object)groupIds.get(i), (Object)group.groupId());
            Assertions.assertEquals((short)Errors.forException((Throwable)e).code(), (short)group.errorCode());
        }
    }

    @Test
    public void testGetErrorDescribedGroupList() {
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expectedDescribedGroupList = Arrays.asList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-1").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-2").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-3").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
        List describedGroupList = ConsumerGroupDescribeRequest.getErrorDescribedGroupList(Arrays.asList("group-id-1", "group-id-2", "group-id-3"), (Errors)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        Assertions.assertEquals(expectedDescribedGroupList, (Object)describedGroupList);
    }
}

