/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.producer.RoundRobinPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoundRobinPartitionerTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(2, "localhost", 101)};

    @Test
    public void testRoundRobinWithUnavailablePartitions() {
        List<PartitionInfo> partitions = Arrays.asList(new PartitionInfo("test", 1, null, NODES, NODES), new PartitionInfo("test", 2, NODES[1], NODES, NODES), new PartitionInfo("test", 0, NODES[0], NODES, NODES));
        int countForPart0 = 0;
        int countForPart2 = 0;
        RoundRobinPartitioner partitioner = new RoundRobinPartitioner();
        Cluster cluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), partitions, Collections.emptySet(), Collections.emptySet());
        for (int i = 1; i <= 100; ++i) {
            int part = partitioner.partition("test", null, null, null, null, cluster);
            Assertions.assertTrue((part == 0 || part == 2 ? 1 : 0) != 0, (String)"We should never choose a leader-less node in round robin");
            if (part == 0) {
                ++countForPart0;
                continue;
            }
            ++countForPart2;
        }
        Assertions.assertEquals((int)countForPart0, (int)countForPart2, (String)"The distribution between two available partitions should be even");
    }

    @Test
    public void testRoundRobinWithKeyBytes() {
        String topicA = "topicA";
        String topicB = "topicB";
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo("topicA", 0, NODES[0], NODES, NODES), new PartitionInfo("topicA", 1, NODES[1], NODES, NODES), new PartitionInfo("topicA", 2, NODES[2], NODES, NODES), new PartitionInfo("topicB", 0, NODES[0], NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), allPartitions, Collections.emptySet(), Collections.emptySet());
        HashMap<Integer, Integer> partitionCount = new HashMap<Integer, Integer>();
        byte[] keyBytes = "key".getBytes();
        RoundRobinPartitioner partitioner = new RoundRobinPartitioner();
        for (int i = 0; i < 30; ++i) {
            int partition = partitioner.partition("topicA", null, keyBytes, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            partitioner.partition("topicB", null, keyBytes, null, null, testCluster);
        }
        Assertions.assertEquals((int)10, (int)((Integer)partitionCount.get(0)));
        Assertions.assertEquals((int)10, (int)((Integer)partitionCount.get(1)));
        Assertions.assertEquals((int)10, (int)((Integer)partitionCount.get(2)));
    }
}

