/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeartbeatTest {
    private final int sessionTimeoutMs = 300;
    private final int heartbeatIntervalMs = 100;
    private final int maxPollIntervalMs = 900;
    private final MockTime time = new MockTime();
    private Heartbeat heartbeat;

    @BeforeEach
    public void setUp() {
        long retryBackoffMs = 10L;
        long retryBackoffMaxMs = 100L;
        GroupRebalanceConfig rebalanceConfig = new GroupRebalanceConfig(300, 900, 100, "group_id", Optional.empty(), null, retryBackoffMs, retryBackoffMaxMs, true);
        this.heartbeat = new Heartbeat(rebalanceConfig, (Time)this.time);
    }

    @Test
    public void testShouldHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(110L);
        Assertions.assertTrue((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testShouldNotHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(50L);
        Assertions.assertFalse((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testTimeToNextHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        Assertions.assertEquals((long)100L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(100L);
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(100L);
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testSessionTimeoutExpired() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        Assertions.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetSession() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        this.heartbeat.resetSessionTimeout();
        Assertions.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(901L);
        this.heartbeat.resetSessionTimeout();
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetTimeouts() {
        this.time.sleep(900L);
        Assertions.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.heartbeat.resetTimeouts();
        Assertions.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)100L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testPollTimeout() {
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(450L);
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(451L);
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }
}

