/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Set;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListGroupsOptionsTest {
    @Test
    public void testForConsumerGroups() {
        ListGroupsOptions options = ListGroupsOptions.forConsumerGroups();
        Assertions.assertTrue((boolean)options.groupStates().isEmpty());
        Assertions.assertEquals(Set.of(GroupType.CONSUMER, GroupType.CLASSIC), (Object)options.types());
        Assertions.assertEquals(Set.of("", "consumer"), (Object)options.protocolTypes());
        options.inGroupStates(Set.of(GroupState.STABLE));
        options.withTypes(Set.of(GroupType.CONSUMER));
        options.withProtocolTypes(Set.of("consumer"));
        Assertions.assertEquals(Set.of(GroupState.STABLE), (Object)options.groupStates());
        Assertions.assertEquals(Set.of(GroupType.CONSUMER), (Object)options.types());
        Assertions.assertEquals(Set.of("consumer"), (Object)options.protocolTypes());
    }

    @Test
    public void testForShareGroups() {
        ListGroupsOptions options = ListGroupsOptions.forShareGroups();
        Assertions.assertTrue((boolean)options.groupStates().isEmpty());
        Assertions.assertEquals(Set.of(GroupType.SHARE), (Object)options.types());
        Assertions.assertTrue((boolean)options.protocolTypes().isEmpty());
        options.inGroupStates(Set.of(GroupState.STABLE));
        options.withTypes(Set.of(GroupType.CONSUMER));
        options.withProtocolTypes(Set.of("consumer"));
        Assertions.assertEquals(Set.of(GroupState.STABLE), (Object)options.groupStates());
        Assertions.assertEquals(Set.of(GroupType.CONSUMER), (Object)options.types());
        Assertions.assertEquals(Set.of("consumer"), (Object)options.protocolTypes());
    }

    @Test
    public void testForStreamsGroups() {
        ListGroupsOptions options = ListGroupsOptions.forStreamsGroups();
        Assertions.assertTrue((boolean)options.groupStates().isEmpty());
        Assertions.assertEquals(Set.of(GroupType.STREAMS), (Object)options.types());
        Assertions.assertTrue((boolean)options.protocolTypes().isEmpty());
        options.inGroupStates(Set.of(GroupState.STABLE));
        options.withTypes(Set.of(GroupType.CONSUMER));
        options.withProtocolTypes(Set.of("consumer"));
        Assertions.assertEquals(Set.of(GroupState.STABLE), (Object)options.groupStates());
        Assertions.assertEquals(Set.of(GroupType.CONSUMER), (Object)options.types());
        Assertions.assertEquals(Set.of("consumer"), (Object)options.protocolTypes());
    }

    @Test
    public void testGroupStates() {
        ListGroupsOptions options = new ListGroupsOptions();
        Assertions.assertTrue((boolean)options.groupStates().isEmpty());
        options.inGroupStates(Set.of(GroupState.DEAD));
        Assertions.assertEquals(Set.of(GroupState.DEAD), (Object)options.groupStates());
        Set<GroupState> groupStates = Set.of(GroupState.values());
        options = new ListGroupsOptions().inGroupStates(groupStates);
        Assertions.assertEquals(groupStates, (Object)options.groupStates());
    }

    @Test
    public void testProtocolTypes() {
        ListGroupsOptions options = new ListGroupsOptions();
        Assertions.assertTrue((boolean)options.protocolTypes().isEmpty());
        options.withProtocolTypes(Set.of("consumer"));
        Assertions.assertEquals(Set.of("consumer"), (Object)options.protocolTypes());
        Set<String> protocolTypes = Set.of("", "consumer", "share");
        options = new ListGroupsOptions().withProtocolTypes(protocolTypes);
        Assertions.assertEquals(protocolTypes, (Object)options.protocolTypes());
    }

    @Test
    public void testTypes() {
        ListGroupsOptions options = new ListGroupsOptions();
        Assertions.assertTrue((boolean)options.types().isEmpty());
        options.withTypes(Set.of(GroupType.CLASSIC));
        Assertions.assertEquals(Set.of(GroupType.CLASSIC), (Object)options.types());
        Set<GroupType> groupTypes = Set.of(GroupType.values());
        options = new ListGroupsOptions().withTypes(groupTypes);
        Assertions.assertEquals(groupTypes, (Object)options.types());
    }
}

