/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Map;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class GroupRebalanceConfigTest {
    @ParameterizedTest
    @EnumSource(value=GroupRebalanceConfig.ProtocolType.class, names={"CONSUMER", "SHARE"})
    void testRackIdIsEmptyIfNoDefined(GroupRebalanceConfig.ProtocolType protocolType) {
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)new ConsumerConfig(Map.of("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer", "value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer")), protocolType);
        Assertions.assertTrue((boolean)groupRebalanceConfig.rackId.isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupRebalanceConfig.ProtocolType.class, names={"CONSUMER", "SHARE"})
    void testRackIdIsEmptyIfValueIsEmptyString(GroupRebalanceConfig.ProtocolType protocolType) {
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)new ConsumerConfig(Map.of("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer", "value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer", "client.rack", "")), protocolType);
        Assertions.assertTrue((boolean)groupRebalanceConfig.rackId.isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupRebalanceConfig.ProtocolType.class, names={"CONSUMER", "SHARE"})
    void testRackIdIsNotEmptyIfDefined(GroupRebalanceConfig.ProtocolType protocolType) {
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)new ConsumerConfig(Map.of("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer", "value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer", "client.rack", "rack1")), protocolType);
        Assertions.assertTrue((boolean)groupRebalanceConfig.rackId.isPresent());
        Assertions.assertEquals((Object)"rack1", groupRebalanceConfig.rackId.get());
    }
}

