/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;

public class CertStores {
    public static final Set<String> KEYSTORE_PROPS = Utils.mkSet((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.type", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.key", "ssl.keystore.certificate.chain"});
    public static final Set<String> TRUSTSTORE_PROPS = Utils.mkSet((Object[])new String[]{"ssl.truststore.location", "ssl.truststore.type", "ssl.truststore.password", "ssl.truststore.certificates"});
    private final Map<String, Object> sslConfig;

    public CertStores(boolean server, String hostName) throws Exception {
        this(server, hostName, new TestSslUtils.CertificateBuilder());
    }

    public CertStores(boolean server, String commonName, String sanHostName) throws Exception {
        this(server, commonName, new TestSslUtils.CertificateBuilder().sanDnsNames(sanHostName));
    }

    private CertStores(boolean server, String commonName, TestSslUtils.CertificateBuilder certBuilder) throws Exception {
        this(server, commonName, "RSA", certBuilder, false);
    }

    private CertStores(boolean server, String commonName, String keyAlgorithm, TestSslUtils.CertificateBuilder certBuilder, boolean usePem) throws Exception {
        String name = server ? "server" : "client";
        Mode mode = server ? Mode.SERVER : Mode.CLIENT;
        File truststoreFile = usePem ? null : TestUtils.tempFile(name + "TS", ".jks");
        this.sslConfig = new TestSslUtils.SslConfigsBuilder(mode).useClientCert(!server).certAlias(name).cn(commonName).createNewTrustStore(truststoreFile).certBuilder(certBuilder).algorithm(keyAlgorithm).usePem(usePem).build();
    }

    public Map<String, Object> getTrustingConfig(CertStores truststoreConfig) {
        HashMap<String, Object> config = new HashMap<String, Object>(this.sslConfig);
        for (String propName : TRUSTSTORE_PROPS) {
            config.put(propName, truststoreConfig.sslConfig.get(propName));
        }
        return config;
    }

    public Map<String, Object> getUntrustingConfig() {
        return this.sslConfig;
    }

    public Map<String, Object> keyStoreProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propName : KEYSTORE_PROPS) {
            props.put(propName, this.sslConfig.get(propName));
        }
        return props;
    }

    public Map<String, Object> trustStoreProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propName : TRUSTSTORE_PROPS) {
            props.put(propName, this.sslConfig.get(propName));
        }
        return props;
    }

    public static class Builder {
        private final boolean isServer;
        private final List<String> sanDns;
        private String cn;
        private InetAddress sanIp;
        private String keyAlgorithm;
        private boolean usePem;

        public Builder(boolean isServer) {
            this.isServer = isServer;
            this.sanDns = new ArrayList<String>();
            this.keyAlgorithm = "RSA";
        }

        public Builder cn(String cn) {
            this.cn = cn;
            return this;
        }

        public Builder addHostName(String hostname) {
            this.sanDns.add(hostname);
            return this;
        }

        public Builder hostAddress(InetAddress hostAddress) {
            this.sanIp = hostAddress;
            return this;
        }

        public Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public Builder usePem(boolean usePem) {
            this.usePem = usePem;
            return this;
        }

        public CertStores build() throws Exception {
            TestSslUtils.CertificateBuilder certBuilder = new TestSslUtils.CertificateBuilder().sanDnsNames(this.sanDns.toArray(new String[0]));
            if (this.sanIp != null) {
                certBuilder = certBuilder.sanIpAddress(this.sanIp);
            }
            return new CertStores(this.isServer, this.cn, this.keyAlgorithm, certBuilder, this.usePem);
        }
    }
}

