/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkThread;
import org.apache.kafka.clients.consumer.internals.ConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsApplicationEvent;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerNetworkThreadTest {
    private ConsumerTestBuilder.ConsumerNetworkThreadTestBuilder testBuilder;
    private Time time;
    private ConsumerMetadata metadata;
    private NetworkClientDelegate networkClient;
    private BlockingQueue<ApplicationEvent> applicationEventsQueue;
    private ApplicationEventProcessor applicationEventProcessor;
    private OffsetsRequestManager offsetsRequestManager;
    private CommitRequestManager commitRequestManager;
    private CoordinatorRequestManager coordinatorRequestManager;
    private HeartbeatRequestManager heartbeatRequestManager;
    private MembershipManager memberhipsManager;
    private ConsumerNetworkThread consumerNetworkThread;
    private MockClient client;
    private SubscriptionState subscriptions;

    @BeforeEach
    public void setup() {
        this.testBuilder = new ConsumerTestBuilder.ConsumerNetworkThreadTestBuilder();
        this.time = this.testBuilder.time;
        this.metadata = this.testBuilder.metadata;
        this.networkClient = this.testBuilder.networkClientDelegate;
        this.client = this.testBuilder.client;
        this.applicationEventsQueue = this.testBuilder.applicationEventQueue;
        this.applicationEventProcessor = this.testBuilder.applicationEventProcessor;
        this.commitRequestManager = (CommitRequestManager)this.testBuilder.commitRequestManager.orElseThrow(IllegalStateException::new);
        this.offsetsRequestManager = this.testBuilder.offsetsRequestManager;
        this.coordinatorRequestManager = (CoordinatorRequestManager)this.testBuilder.coordinatorRequestManager.orElseThrow(IllegalStateException::new);
        this.heartbeatRequestManager = (HeartbeatRequestManager)this.testBuilder.heartbeatRequestManager.orElseThrow(IllegalStateException::new);
        this.memberhipsManager = (MembershipManager)this.testBuilder.membershipManager.orElseThrow(IllegalStateException::new);
        this.consumerNetworkThread = this.testBuilder.consumerNetworkThread;
        this.subscriptions = this.testBuilder.subscriptions;
        this.consumerNetworkThread.initializeResources();
    }

    @AfterEach
    public void tearDown() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
        }
    }

    @Test
    public void testStartupAndTearDown() throws InterruptedException {
        this.consumerNetworkThread.start();
        TestCondition isStarted = () -> this.consumerNetworkThread.isRunning();
        TestCondition isClosed = () -> !this.consumerNetworkThread.isRunning() && !this.consumerNetworkThread.isAlive();
        TestUtils.waitForCondition(isStarted, "The consumer network thread did not start within 15000 ms");
        this.consumerNetworkThread.close(Duration.ofMillis(15000L));
        TestUtils.waitForCondition(isClosed, "The consumer network thread did not stop within 15000 ms");
    }

    @Test
    public void testApplicationEvent() {
        CommitApplicationEvent e = new CommitApplicationEvent(new HashMap(), Optional.empty());
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor, (VerificationMode)Mockito.times((int)1))).process((ApplicationEvent)e);
    }

    @Test
    public void testMetadataUpdateEvent() {
        NewTopicsMetadataUpdateRequestEvent e = new NewTopicsMetadataUpdateRequestEvent();
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdateForNewTopics();
    }

    @Test
    public void testCommitEvent() {
        CommitApplicationEvent e = new CommitApplicationEvent(new HashMap(), Optional.empty());
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(CommitApplicationEvent.class));
    }

    @Test
    public void testListOffsetsEventIsProcessed() {
        Map<TopicPartition, Long> timestamps = Collections.singletonMap(new TopicPartition("topic1", 1), 5L);
        ListOffsetsApplicationEvent e = new ListOffsetsApplicationEvent(timestamps, true);
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ListOffsetsApplicationEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testResetPositionsEventIsProcessed() {
        ResetPositionsApplicationEvent e = new ResetPositionsApplicationEvent();
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ResetPositionsApplicationEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testResetPositionsProcessFailureIsIgnored() {
        ((OffsetsRequestManager)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException()}).when((Object)this.offsetsRequestManager)).resetPositionsIfNeeded();
        ResetPositionsApplicationEvent event = new ResetPositionsApplicationEvent();
        this.applicationEventsQueue.add((ApplicationEvent)event);
        Assertions.assertDoesNotThrow(() -> this.consumerNetworkThread.runOnce());
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ResetPositionsApplicationEvent.class));
    }

    @Test
    public void testValidatePositionsEventIsProcessed() {
        ValidatePositionsApplicationEvent e = new ValidatePositionsApplicationEvent();
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ValidatePositionsApplicationEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testAssignmentChangeEvent() {
        HashMap<TopicPartition, OffsetAndMetadata> offset = this.mockTopicPartitionOffset();
        long currentTimeMs = this.time.milliseconds();
        AssignmentChangeApplicationEvent e = new AssignmentChangeApplicationEvent(offset, currentTimeMs);
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(AssignmentChangeApplicationEvent.class));
        ((NetworkClientDelegate)Mockito.verify((Object)this.networkClient, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager, (VerificationMode)Mockito.times((int)1))).updateAutoCommitTimer(currentTimeMs);
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager, (VerificationMode)Mockito.times((int)1))).maybeAutoCommitAllConsumedAsync();
    }

    @Test
    void testFetchTopicMetadata() {
        this.applicationEventsQueue.add((ApplicationEvent)new TopicMetadataApplicationEvent("topic", Long.MAX_VALUE));
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(TopicMetadataApplicationEvent.class));
    }

    @Test
    void testPollResultTimer() {
        NetworkClientDelegate.UnsentRequest req = new NetworkClientDelegate.UnsentRequest((AbstractRequest.Builder)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id()).setKey("foobar")), Optional.empty());
        req.setTimer(this.time, 500L);
        NetworkClientDelegate.PollResult success = new NetworkClientDelegate.PollResult(10L, Collections.singletonList(req));
        Assertions.assertEquals((long)10L, (long)this.networkClient.addAll(success));
        NetworkClientDelegate.PollResult failure = new NetworkClientDelegate.PollResult(10L, new ArrayList());
        Assertions.assertEquals((long)10L, (long)this.networkClient.addAll(failure));
    }

    @Test
    void testMaximumTimeToWait() {
        Assertions.assertEquals((long)5000L, (long)this.consumerNetworkThread.maximumTimeToWait());
        this.consumerNetworkThread.runOnce();
        Assertions.assertEquals((long)1000L, (long)this.consumerNetworkThread.maximumTimeToWait());
    }

    @Test
    void testRequestManagersArePolledOnce() {
        this.consumerNetworkThread.runOnce();
        this.testBuilder.requestManagers.entries().forEach(rmo -> rmo.ifPresent(rm -> ((RequestManager)Mockito.verify((Object)rm, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong())));
        this.testBuilder.requestManagers.entries().forEach(rmo -> rmo.ifPresent(rm -> ((RequestManager)Mockito.verify((Object)rm, (VerificationMode)Mockito.times((int)1))).maximumTimeToWait(ArgumentMatchers.anyLong())));
        ((NetworkClientDelegate)Mockito.verify((Object)this.networkClient, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    void testEnsureMetadataUpdateOnPoll() {
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith(2, Collections.emptyMap());
        this.client.prepareMetadataUpdate(metadataResponse);
        this.metadata.requestUpdate(false);
        this.consumerNetworkThread.runOnce();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).updateWithCurrentRequestVersion((MetadataResponse)ArgumentMatchers.eq((Object)metadataResponse), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyLong());
    }

    @Test
    void testEnsureEventsAreCompleted() {
        Node node = (Node)this.metadata.fetch().nodes().get(0);
        this.coordinatorRequestManager.markCoordinatorUnknown("test", this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"group-id", (Node)node));
        this.prepareOffsetCommitRequest(new HashMap<TopicPartition, Long>(), Errors.NONE, false);
        CompletableApplicationEvent event1 = (CompletableApplicationEvent)Mockito.spy((Object)new CommitApplicationEvent(Collections.emptyMap(), Optional.empty()));
        CommitApplicationEvent event2 = new CommitApplicationEvent(Collections.emptyMap(), Optional.empty());
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)event1.future()).thenReturn(future);
        this.applicationEventsQueue.add((ApplicationEvent)event1);
        this.applicationEventsQueue.add((ApplicationEvent)event2);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)this.applicationEventsQueue.isEmpty());
        this.consumerNetworkThread.cleanup();
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    private void prepareOffsetCommitRequest(Map<TopicPartition, Long> expectedOffsets, Errors error, boolean disconnected) {
        Map<TopicPartition, Errors> errors = this.partitionErrors(expectedOffsets.keySet(), error);
        this.client.prepareResponse(this.offsetCommitRequestMatcher(expectedOffsets), (AbstractResponse)this.offsetCommitResponse(errors), disconnected);
    }

    private Map<TopicPartition, Errors> partitionErrors(Collection<TopicPartition> partitions, Errors error) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitions) {
            errors.put(partition, error);
        }
        return errors;
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private MockClient.RequestMatcher offsetCommitRequestMatcher(Map<TopicPartition, Long> expectedOffsets) {
        return body -> {
            OffsetCommitRequest req = (OffsetCommitRequest)body;
            Map offsets = req.offsets();
            if (offsets.size() != expectedOffsets.size()) {
                return false;
            }
            for (Map.Entry expectedOffset : expectedOffsets.entrySet()) {
                if (!offsets.containsKey(expectedOffset.getKey())) {
                    return false;
                }
                Long actualOffset = (Long)offsets.get(expectedOffset.getKey());
                if (actualOffset.equals(expectedOffset.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    private HashMap<TopicPartition, OffsetAndMetadata> mockTopicPartitionOffset() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L));
        return topicPartitionOffsets;
    }
}

