/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.RefreshingHttpsJwks;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwk.HttpsJwks;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RefreshingHttpsJwksTest
extends OAuthBearerTest {
    private static final int REFRESH_MS = 5000;
    private static final int RETRY_BACKOFF_MS = 50;
    private static final int RETRY_BACKOFF_MAX_MS = 2000;

    @Test
    public void testBasicScheduleRefresh() throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)2))).refresh();
        }
    }

    @Test
    public void testMaybeExpediteRefreshNoDelay() throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    @Test
    public void testMaybeExpediteRefreshDelays() throws Exception {
        this.assertMaybeExpediteRefreshWithDelay(59999L, false);
        this.assertMaybeExpediteRefreshWithDelay(60000L, true);
        this.assertMaybeExpediteRefreshWithDelay(60001L, true);
    }

    @Test
    public void testLongKey() throws Exception {
        char[] keyIdChars = new char[1001];
        Arrays.fill(keyIdChars, '0');
        String keyId = new String(keyIdChars);
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
        }
    }

    @Test
    public void testSecondaryRefreshAfterElapsedDelay() throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)2))).refresh();
            time.sleep(5001L);
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)3))).refresh();
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    private ScheduledExecutorService mockExecutorService(MockTime time) {
        MockExecutorService mockExecutorService = new MockExecutorService(time);
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ((ScheduledExecutorService)Mockito.doAnswer(invocation -> {
            Runnable command = (Runnable)invocation.getArgument(0, Runnable.class);
            long delay = (Long)invocation.getArgument(1, Long.class);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(2, TimeUnit.class)));
            return mockExecutorService.schedule(() -> {
                command.run();
                return null;
            }, unit.toMillis(delay), null);
        }).when((Object)executorService)).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
        ((ScheduledExecutorService)Mockito.doAnswer(invocation -> {
            Runnable command = (Runnable)invocation.getArgument(0, Runnable.class);
            long initialDelay = (Long)invocation.getArgument(1, Long.class);
            long period = (Long)invocation.getArgument(2, Long.class);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(3, TimeUnit.class)));
            return mockExecutorService.schedule(() -> {
                command.run();
                return null;
            }, unit.toMillis(initialDelay), period);
        }).when((Object)executorService)).scheduleAtFixedRate((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
        return executorService;
    }

    private void assertMaybeExpediteRefreshWithDelay(long sleepDelay, boolean shouldBeScheduled) throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            time.sleep(sleepDelay);
            Assertions.assertEquals((Object)shouldBeScheduled, (Object)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    private RefreshingHttpsJwks getRefreshingHttpsJwks(MockTime time, HttpsJwks httpsJwks) {
        return new RefreshingHttpsJwks((Time)time, httpsJwks, 5000L, 50L, 2000L, this.mockExecutorService(time));
    }

    private HttpsJwks spyHttpsJwks() {
        HttpsJwks httpsJwks = new HttpsJwks("https://www.example.com");
        SimpleResponse simpleResponse = new SimpleResponse(){

            public int getStatusCode() {
                return 200;
            }

            public String getStatusMessage() {
                return "OK";
            }

            public Collection<String> getHeaderNames() {
                return Collections.emptyList();
            }

            public List<String> getHeaderValues(String name) {
                return Collections.emptyList();
            }

            public String getBody() {
                return "{\"keys\": []}";
            }
        };
        httpsJwks.setSimpleHttpGet(l -> simpleResponse);
        return (HttpsJwks)Mockito.spy((Object)httpsJwks);
    }

    private class MockExecutorService
    implements MockTime.Listener {
        private final MockTime time;
        private final TreeMap<Long, List<AbstractMap.SimpleEntry<Long, KafkaFutureImpl<Long>>>> waiters = new TreeMap();

        public MockExecutorService(MockTime time) {
            this.time = time;
            time.addListener(this);
        }

        @Override
        public synchronized void onTimeUpdated() {
            Map.Entry<Long, List<AbstractMap.SimpleEntry<Long, KafkaFutureImpl<Long>>>> entry;
            long timeMs = this.time.milliseconds();
            while ((entry = this.waiters.firstEntry()) != null && entry.getKey() <= timeMs) {
                for (AbstractMap.SimpleEntry<Long, KafkaFutureImpl<Long>> pair : entry.getValue()) {
                    pair.getValue().complete((Object)timeMs);
                    if (pair.getKey() == null) continue;
                    this.addWaiter(entry.getKey() + pair.getKey(), pair.getKey(), pair.getValue());
                }
                this.waiters.remove(entry.getKey());
            }
        }

        private synchronized void addWaiter(long delayMs, Long period, KafkaFutureImpl<Long> waiter) {
            long timeMs = this.time.milliseconds();
            if (delayMs <= 0L) {
                waiter.complete((Object)timeMs);
            } else {
                long triggerTimeMs = timeMs + delayMs;
                List futures = this.waiters.computeIfAbsent(triggerTimeMs, k -> new ArrayList());
                futures.add(new AbstractMap.SimpleEntry<Long, KafkaFutureImpl<Long>>(period, waiter));
            }
        }

        public <T> ScheduledFuture<T> schedule(Callable<T> callable, long delayMs, Long period) {
            KafkaFutureImpl waiter = new KafkaFutureImpl();
            waiter.thenApply(now -> {
                try {
                    callable.call();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return null;
            });
            this.addWaiter(delayMs, period, (KafkaFutureImpl<Long>)waiter);
            return null;
        }
    }
}

