/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.RefreshingHttpsJwks;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwk.HttpsJwks;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RefreshingHttpsJwksTest
extends OAuthBearerTest {
    private static final int REFRESH_MS = 5000;
    private static final int RETRY_BACKOFF_MS = 50;
    private static final int RETRY_BACKOFF_MAX_MS = 2000;

    @Test
    public void testBasicScheduleRefresh() throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
        }
    }

    @Test
    public void testMaybeExpediteRefreshNoDelay() throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    @Test
    public void testMaybeExpediteRefreshDelays() throws Exception {
        this.assertMaybeExpediteRefreshWithDelay(59999L, false);
        this.assertMaybeExpediteRefreshWithDelay(60000L, true);
        this.assertMaybeExpediteRefreshWithDelay(60001L, true);
    }

    @Test
    public void testLongKey() throws Exception {
        char[] keyIdChars = new char[1001];
        Arrays.fill(keyIdChars, '0');
        String keyId = new String(keyIdChars);
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
        }
    }

    @Test
    public void testSecondaryRefreshAfterElapsedDelay() throws Exception {
        String keyId = "abc123";
        Time time = MockTime.SYSTEM;
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)1))).refresh();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            time.sleep(5001L);
            ((HttpsJwks)Mockito.verify((Object)httpsJwks, (VerificationMode)Mockito.times((int)3))).refresh();
            Assertions.assertFalse((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    private void assertMaybeExpediteRefreshWithDelay(long sleepDelay, boolean shouldBeScheduled) throws Exception {
        String keyId = "abc123";
        MockTime time = new MockTime();
        HttpsJwks httpsJwks = this.spyHttpsJwks();
        try (RefreshingHttpsJwks refreshingHttpsJwks = this.getRefreshingHttpsJwks(time, httpsJwks);){
            refreshingHttpsJwks.init();
            Assertions.assertTrue((boolean)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
            time.sleep(sleepDelay);
            Assertions.assertEquals((Object)shouldBeScheduled, (Object)refreshingHttpsJwks.maybeExpediteRefresh(keyId));
        }
    }

    private RefreshingHttpsJwks getRefreshingHttpsJwks(Time time, HttpsJwks httpsJwks) {
        return new RefreshingHttpsJwks(time, httpsJwks, 5000L, 50L, 2000L);
    }

    private HttpsJwks spyHttpsJwks() {
        HttpsJwks httpsJwks = new HttpsJwks("https://www.example.com");
        SimpleResponse simpleResponse = new SimpleResponse(){

            public int getStatusCode() {
                return 200;
            }

            public String getStatusMessage() {
                return "OK";
            }

            public Collection<String> getHeaderNames() {
                return Collections.emptyList();
            }

            public List<String> getHeaderValues(String name) {
                return Collections.emptyList();
            }

            public String getBody() {
                return "{\"keys\": []}";
            }
        };
        httpsJwks.setSimpleHttpGet(l -> simpleResponse);
        return (HttpsJwks)Mockito.spy((Object)httpsJwks);
    }
}

