/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import org.apache.kafka.common.protocol.ApiKeys;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProtoUtilsTest {
    @Test
    public void testDelayedAllocationSchemaDetection() {
        block3: for (ApiKeys key : ApiKeys.values()) {
            switch (key) {
                case PRODUCE: 
                case JOIN_GROUP: 
                case SYNC_GROUP: 
                case SASL_AUTHENTICATE: 
                case EXPIRE_DELEGATION_TOKEN: 
                case RENEW_DELEGATION_TOKEN: 
                case ALTER_USER_SCRAM_CREDENTIALS: 
                case ENVELOPE: 
                case CONSUMER_GROUP_HEARTBEAT: {
                    Assertions.assertTrue((boolean)key.requiresDelayedAllocation, (String)(key + " should require delayed allocation"));
                    continue block3;
                }
                default: {
                    if (key.forwardable) {
                        Assertions.assertTrue((boolean)key.requiresDelayedAllocation, (String)(key + " should require delayed allocation since it is forwardable"));
                        continue block3;
                    }
                    Assertions.assertFalse((boolean)key.requiresDelayedAllocation, (String)(key + " should not require delayed allocation"));
                }
            }
        }
    }
}

