/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.ExponentialBackoff;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialBackoffTest {
    @Test
    public void testExponentialBackoff() {
        long scaleFactor = 100L;
        int ratio = 2;
        long backoffMax = 2000L;
        double jitter = 0.2;
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(scaleFactor, ratio, backoffMax, jitter);
        for (int i = 0; i <= 100; ++i) {
            for (int attempts = 0; attempts <= 10; ++attempts) {
                if (attempts <= 4) {
                    Assert.assertEquals((double)((double)scaleFactor * Math.pow(ratio, attempts)), (double)exponentialBackoff.backoff((long)attempts), (double)((double)scaleFactor * Math.pow(ratio, attempts) * jitter));
                    continue;
                }
                Assert.assertTrue(((double)exponentialBackoff.backoff((long)attempts) <= (double)backoffMax * (1.0 + jitter) ? 1 : 0) != 0);
            }
        }
    }
}

