/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.EnumSet;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ApiKeysTest {
    @Test(expected=IllegalArgumentException.class)
    public void testForIdWithInvalidIdLow() {
        ApiKeys.forId((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForIdWithInvalidIdHigh() {
        ApiKeys.forId((int)10000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void schemaVersionOutOfRange() {
        ApiKeys.PRODUCE.requestSchema((short)ApiKeys.PRODUCE.requestSchemas.length);
    }

    @Test
    public void testAlterIsrIsClusterAction() {
        Assertions.assertTrue((boolean)ApiKeys.ALTER_ISR.clusterAction);
    }

    @Test
    public void testResponseThrottleTime() {
        EnumSet<ApiKeys> authenticationKeys = EnumSet.of(ApiKeys.SASL_HANDSHAKE, ApiKeys.SASL_AUTHENTICATE);
        EnumSet<ApiKeys> clusterActionsWithThrottleTimeMs = EnumSet.of(ApiKeys.ALTER_ISR);
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema responseSchema = apiKey.responseSchema(apiKey.latestVersion());
            BoundField throttleTimeField = responseSchema.get(CommonFields.THROTTLE_TIME_MS.name);
            if (apiKey.clusterAction && !clusterActionsWithThrottleTimeMs.contains(apiKey) || authenticationKeys.contains(apiKey)) {
                Assert.assertNull((String)("Unexpected throttle time field: " + apiKey), (Object)throttleTimeField);
                continue;
            }
            Assert.assertNotNull((String)("Throttle time field missing: " + apiKey), (Object)throttleTimeField);
        }
    }
}

