/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.softlayer.binders.NotesToJson;
import org.jclouds.softlayer.binders.TagToJson;
import org.jclouds.softlayer.binders.VirtualGuestToJson;
import org.jclouds.softlayer.domain.ContainerVirtualGuestConfiguration;
import org.jclouds.softlayer.domain.VirtualGuest;

@RequestFilters(value={BasicAuthentication.class})
@Path(value="/v{jclouds.api-version}")
@Consumes(value={"application/json"})
public interface VirtualGuestApi {
    public static final String GUEST_MASK = "id;hostname;domain;fullyQualifiedDomainName;powerState;maxCpu;maxMemory;statusId;operatingSystem.passwords;primaryBackendIpAddress;primaryIpAddress;activeTransactionCount;blockDevices.diskImage;datacenter;tagReferences;privateNetworkOnlyFlag;sshKeys";
    public static final String NOTES_MASK = "id;notes";

    @Named(value="VirtualGuests:create")
    @POST
    @Path(value="SoftLayer_Virtual_Guest")
    @Produces(value={"application/json"})
    public VirtualGuest createVirtualGuest(@BinderParam(value=VirtualGuestToJson.class) VirtualGuest var1);

    @Named(value="VirtualGuests:get")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/getObject")
    @QueryParams(keys={"objectMask"}, values={"id;hostname;domain;fullyQualifiedDomainName;powerState;maxCpu;maxMemory;statusId;operatingSystem.passwords;primaryBackendIpAddress;primaryIpAddress;activeTransactionCount;blockDevices.diskImage;datacenter;tagReferences;privateNetworkOnlyFlag;sshKeys"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualGuest getVirtualGuest(@PathParam(value="id") long var1);

    @Named(value="VirtualGuests:get")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/getObject")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualGuest getVirtualGuestFiltered(@PathParam(value="id") long var1, @QueryParam(value="objectMask") String var3);

    @Named(value="VirtualGuests:delete")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/deleteObject")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteVirtualGuest(@PathParam(value="id") long var1);

    @Named(value="VirtualGuests:getCreateObjectOptions")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/getCreateObjectOptions")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ContainerVirtualGuestConfiguration getCreateObjectOptions();

    @Named(value="VirtualGuest:rebootHard")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/rebootHard.json")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void rebootHardVirtualGuest(@PathParam(value="id") long var1);

    @Named(value="VirtualGuest:pause")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/pause.json")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void pauseVirtualGuest(@PathParam(value="id") long var1);

    @Named(value="VirtualGuest:resume")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/resume.json")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void resumeVirtualGuest(@PathParam(value="id") long var1);

    @Named(value="VirtualGuest:setTags")
    @POST
    @Path(value="/SoftLayer_Virtual_Guest/{id}/setTags")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean setTags(@PathParam(value="id") long var1, @BinderParam(value=TagToJson.class) Set<String> var3);

    @Named(value="VirtualGuest:setNotes")
    @POST
    @Path(value="/SoftLayer_Virtual_Guest/{id}/editObject")
    @Produces(value={"application/json"})
    public boolean setNotes(@PathParam(value="id") long var1, @BinderParam(value=NotesToJson.class) String var3);

    @Named(value="VirtualGuest:getNotes")
    @GET
    @Path(value="/SoftLayer_Virtual_Guest/{id}/getObject")
    @Produces(value={"application/json"})
    @QueryParams(keys={"objectMask"}, values={"id;notes"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualGuest getNotes(@PathParam(value="id") long var1);
}

