/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.config;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.functions.DatacenterToLocation;
import org.jclouds.softlayer.compute.functions.OperatingSystemToImage;
import org.jclouds.softlayer.compute.functions.VirtualGuestToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToNodeMetadata;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.compute.strategy.SoftLayerComputeServiceAdapter;
import org.jclouds.softlayer.domain.ContainerVirtualGuestConfiguration;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.VirtualGuest;

public class SoftLayerComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualGuest, Hardware, OperatingSystem, Datacenter> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualGuest, Hardware, OperatingSystem, Datacenter>>(){}).to(SoftLayerComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualGuest, NodeMetadata>>(){}).to(VirtualGuestToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<OperatingSystem, Image>>(){}).to(OperatingSystemToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualGuest, Hardware>>(){}).to(VirtualGuestToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Datacenter, Location>>(){}).to(DatacenterToLocation.class);
        this.bind(TemplateOptions.class).to(SoftLayerTemplateOptions.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualGuest, Hardware, OperatingSystem, Datacenter>(){});
    }

    @Provides
    @Singleton
    @Memoized
    public final Supplier<ContainerVirtualGuestConfiguration> getCreateObjectOptions(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, final SoftLayerApi api) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)new Supplier<ContainerVirtualGuestConfiguration>(){

            public ContainerVirtualGuestConfiguration get() {
                return api.getVirtualGuestApi().getCreateObjectOptions();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)api).add("method", (Object)"virtualGuestApi.getCreateObjectOptions").toString();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }
}

