/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.loadbalancer.CreateLoadBalancerRequestBinder;
import org.jclouds.profitbricks.binder.loadbalancer.DeregisterLoadBalancerRequestBinder;
import org.jclouds.profitbricks.binder.loadbalancer.RegisterLoadBalancerRequestBinder;
import org.jclouds.profitbricks.binder.loadbalancer.UpdateLoadBalancerRequestBinder;
import org.jclouds.profitbricks.domain.LoadBalancer;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.loadbalancer.LoadBalancerIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.loadbalancer.LoadBalancerListResponseHandler;
import org.jclouds.profitbricks.http.parser.loadbalancer.LoadBalancerResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface LoadBalancerApi {
    @POST
    @Named(value="loadbalancer:getall")
    @Payload(value="<ws:getAllLoadBalancers/>")
    @XMLResponseParser(value=LoadBalancerListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<LoadBalancer> getAllLoadBalancers();

    @POST
    @Named(value="loadbalancer:get")
    @Payload(value="<ws:getLoadBalancer><loadBalancerId>{id}</loadBalancerId></ws:getLoadBalancer>")
    @XMLResponseParser(value=LoadBalancerResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public LoadBalancer getLoadBalancer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="loadbalancer:create")
    @MapBinder(value=CreateLoadBalancerRequestBinder.class)
    @XMLResponseParser(value=LoadBalancerIdOnlyResponseHandler.class)
    public String createLoadBalancer(@PayloadParam(value="loadbalancer") LoadBalancer.Request.CreatePayload var1);

    @POST
    @Named(value="loadbalancer:register")
    @MapBinder(value=RegisterLoadBalancerRequestBinder.class)
    @XMLResponseParser(value=LoadBalancerResponseHandler.class)
    public LoadBalancer registerLoadBalancer(@PayloadParam(value="loadbalancer") LoadBalancer.Request.RegisterPayload var1);

    @POST
    @Named(value="loadbalancer:deregister")
    @MapBinder(value=DeregisterLoadBalancerRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String deregisterLoadBalancer(@PayloadParam(value="loadbalancer") LoadBalancer.Request.DeregisterPayload var1);

    @POST
    @Named(value="loadbalancer:delete")
    @Payload(value="<ws:deleteLoadBalancer><loadBalancerId>{id}</loadBalancerId></ws:deleteLoadBalancer>")
    public boolean deleteLoadBalancer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="loadbalancer:update")
    @MapBinder(value=UpdateLoadBalancerRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String updateLoadBalancer(@PayloadParam(value="loadbalancer") LoadBalancer.Request.UpdatePayload var1);
}

