/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.domain.Image;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.image.ImageInfoResponseHandler;
import org.jclouds.profitbricks.http.parser.image.ImageListResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface ImageApi {
    @POST
    @Named(value="image:getall")
    @Payload(value="<ws:getAllImages/>")
    @XMLResponseParser(value=ImageListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Image> getAllImages();

    @POST
    @Named(value="image:get")
    @Payload(value="<ws:getImage><imageId>{id}</imageId></ws:getImage>")
    @XMLResponseParser(value=ImageInfoResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Image getImage(@PayloadParam(value="id") String var1);
}

