/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_IpBlock;
import org.jclouds.profitbricks.domain.AutoValue_IpBlock_PublicIp;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.util.Preconditions;

@AutoValue
public abstract class IpBlock {
    public abstract String id();

    public abstract Location location();

    public abstract List<PublicIp> publicIps();

    @Nullable
    public abstract List<String> ips();

    public static Builder builder() {
        return new AutoValue_IpBlock.Builder().publicIps((List<PublicIp>)ImmutableList.of()).ips((List<String>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder location(Location var1);

        public abstract Builder publicIps(List<PublicIp> var1);

        public abstract Builder ips(List<String> var1);

        abstract IpBlock autoBuild();

        public IpBlock build() {
            IpBlock ipBlock = this.autoBuild();
            Preconditions.checkIps(ipBlock.ips());
            return ipBlock.toBuilder().publicIps((List<PublicIp>)ImmutableList.copyOf(ipBlock.publicIps())).ips((List<String>)ImmutableList.copyOf(ipBlock.ips())).autoBuild();
        }
    }

    @AutoValue
    public static abstract class PublicIp {
        public abstract String ip();

        @Nullable
        public abstract String nicId();

        public static Builder builder() {
            return new AutoValue_IpBlock_PublicIp.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder ip(String var1);

            public abstract Builder nicId(String var1);

            abstract PublicIp autoBuild();

            public PublicIp build() {
                PublicIp publicIp = this.autoBuild();
                Preconditions.checkIp(publicIp.ip());
                return publicIp;
            }
        }
    }
}

