/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_DataCenter;
import org.jclouds.profitbricks.domain.AutoValue_DataCenter_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_DataCenter_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.util.Preconditions;

@AutoValue
public abstract class DataCenter {
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract int version();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract Location location();

    @Nullable
    public abstract List<Server> servers();

    @Nullable
    public abstract List<Storage> storages();

    public static Builder builder() {
        return new AutoValue_DataCenter.Builder().servers((List<Server>)ImmutableList.of()).storages((List<Storage>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder version(int var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder location(Location var1);

        public abstract Builder servers(List<Server> var1);

        public abstract Builder storages(List<Storage> var1);

        abstract DataCenter autoBuild();

        public DataCenter build() {
            DataCenter built = this.autoBuild();
            return built.toBuilder().servers((List<Server>)ImmutableList.copyOf(built.servers())).storages((List<Storage>)ImmutableList.copyOf(built.storages())).autoBuild();
        }
    }

    public static final class Request {
        public static CreatePayload creatingPayload(String name, Location location) {
            AutoValue_DataCenter_Request_CreatePayload payload = new AutoValue_DataCenter_Request_CreatePayload(name, location);
            Preconditions.checkInvalidChars(((CreatePayload)payload).name());
            return payload;
        }

        public static UpdatePayload updatingPayload(String id, String name) {
            AutoValue_DataCenter_Request_UpdatePayload payload = new AutoValue_DataCenter_Request_UpdatePayload(id, name);
            Preconditions.checkInvalidChars(((UpdatePayload)payload).name());
            return payload;
        }

        @AutoValue
        public static abstract class CreatePayload {
            public abstract String name();

            public abstract Location location();
        }

        @AutoValue
        public static abstract class UpdatePayload {
            public abstract String id();

            public abstract String name();
        }
    }
}

