/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.strategy;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.profitbricks.domain.DataCenter;

@Beta
public class TemplateWithDataCenter
implements Template {
    private final Template delegate;
    private final DataCenter dataCenter;

    TemplateWithDataCenter(Template delegate, DataCenter dataCenter) {
        this.delegate = (Template)Preconditions.checkNotNull((Object)delegate, (Object)"delegate cannot be null");
        this.dataCenter = (DataCenter)Preconditions.checkNotNull((Object)dataCenter, (Object)"dataCenter cannot be null");
    }

    public DataCenter getDataCenter() {
        return this.dataCenter;
    }

    public Template clone() {
        return new TemplateWithDataCenter(this.delegate.clone(), this.dataCenter);
    }

    public Hardware getHardware() {
        return this.delegate.getHardware();
    }

    public Image getImage() {
        return this.delegate.getImage();
    }

    public Location getLocation() {
        return this.delegate.getLocation();
    }

    public TemplateOptions getOptions() {
        return this.delegate.getOptions();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataCenter == null ? 0 : this.dataCenter.hashCode());
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateWithDataCenter other = (TemplateWithDataCenter)obj;
        if (this.dataCenter == null ? other.dataCenter != null : !this.dataCenter.equals(other.dataCenter)) {
            return false;
        }
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals((Object)other.delegate));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

