/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.Plan;
import org.jclouds.packet.domain.internal.PaginatedCollection;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.filters.AddApiVersionToRequest;
import org.jclouds.packet.filters.AddXAuthTokenToRequest;
import org.jclouds.packet.functions.BaseToPagedIterable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;

@Path(value="/plans")
@Consumes(value={"application/json"})
@RequestFilters(value={AddXAuthTokenToRequest.class, AddApiVersionToRequest.class})
public interface PlanApi {
    @Named(value="plan:list")
    @GET
    @ResponseParser(value=ParsePlans.class)
    @Transform(value=ParsePlans.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Plan> list();

    @Named(value="plan:list")
    @GET
    @ResponseParser(value=ParsePlans.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Plan> list(ListOptions var1);

    public static final class ParsePlans
    extends ParseJson<Plans> {
        @Inject
        ParsePlans(Json json) {
            super(json, TypeLiteral.get(Plans.class));
        }

        private static class Plans
        extends PaginatedCollection<Plan> {
            @ConstructorProperties(value={"plans", "meta"})
            public Plans(List<Plan> items, PaginatedCollection.Meta meta) {
                super(items, meta);
            }
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Plan, ListOptions> {
            @Inject
            ToPagedIterable(PacketApi api, Function<Href, ListOptions> hrefToOptions) {
                super(api, hrefToOptions);
            }

            @Override
            protected IterableWithMarker<Plan> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.planApi().list(options);
            }
        }
    }
}

