/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.location.Provider;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.compute.PacketComputeServiceAdapter;
import org.jclouds.packet.compute.functions.DeviceStateToStatus;
import org.jclouds.packet.compute.functions.DeviceToNodeMetadata;
import org.jclouds.packet.compute.functions.FacilityToLocation;
import org.jclouds.packet.compute.functions.OperatingSystemToImage;
import org.jclouds.packet.compute.functions.PlanToHardware;
import org.jclouds.packet.compute.options.PacketTemplateOptions;
import org.jclouds.packet.compute.strategy.CreateSshKeysThenCreateNodes;
import org.jclouds.packet.domain.Device;
import org.jclouds.packet.domain.Facility;
import org.jclouds.packet.domain.OperatingSystem;
import org.jclouds.packet.domain.Plan;
import org.jclouds.util.Predicates2;

public class PacketComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Device, Plan, OperatingSystem, Facility> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Device, Plan, OperatingSystem, Facility>>(){}).to(PacketComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, NodeMetadata>>(){}).to(DeviceToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Plan, Hardware>>(){}).to(PlanToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<OperatingSystem, Image>>(){}).to(OperatingSystemToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Facility, Location>>(){}).to(FacilityToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device.State, NodeMetadata.Status>>(){}).to(DeviceStateToStatus.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Device, Plan, OperatingSystem, Facility>(){});
        this.bind(TemplateOptions.class).to(PacketTemplateOptions.class);
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateSshKeysThenCreateNodes.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<String> provideDeviceRunningPredicate(PacketApi api, @Provider Supplier<Credentials> creds, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DeviceInStatusPredicate(api, ((Credentials)creds.get()).identity, Device.State.ACTIVE), (long)timeouts.nodeRunning, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<String> provideDeviceSuspendedPredicate(PacketApi api, @Provider Supplier<Credentials> creds, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DeviceInStatusPredicate(api, ((Credentials)creds.get()).identity, Device.State.INACTIVE), (long)timeouts.nodeSuspended, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<String> provideDeviceTerminatedPredicate(PacketApi api, @Provider Supplier<Credentials> creds, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DeviceTerminatedPredicate(api, ((Credentials)creds.get()).identity), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @VisibleForTesting
    static class DeviceInStatusPredicate
    implements Predicate<String> {
        private final PacketApi api;
        private final String projectId;
        private final Device.State state;

        public DeviceInStatusPredicate(PacketApi api, String projectId, Device.State state) {
            this.api = (PacketApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"projectId must not be null");
            this.state = (Device.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state must not be null"));
        }

        public boolean apply(String input) {
            Preconditions.checkNotNull((Object)input, (Object)"device id");
            Device device = this.api.deviceApi(this.projectId).get(input);
            return device != null && this.state == device.state();
        }
    }

    @VisibleForTesting
    static class DeviceTerminatedPredicate
    implements Predicate<String> {
        private final PacketApi api;
        private final String projectId;

        public DeviceTerminatedPredicate(PacketApi api, String projectId) {
            this.api = (PacketApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"projectId must not be null");
        }

        public boolean apply(String input) {
            Preconditions.checkNotNull((Object)input, (Object)"device id");
            Device device = this.api.deviceApi(this.projectId).get(input);
            return device == null;
        }
    }
}

