/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.googlecomputeengine.options.AutoValue_TargetHttpProxyOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class TargetHttpProxyOptions {
    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract URI urlMap();

    @SerializedNames(value={"name", "description", "urlMap"})
    static TargetHttpProxyOptions create(String name, String description, URI urlMap) {
        return new AutoValue_TargetHttpProxyOptions(name, description, urlMap);
    }

    TargetHttpProxyOptions() {
    }

    public static class Builder {
        private String name;
        private String description;
        private URI urlMap;

        public Builder(String name, URI urlMap) {
            this.name = name;
            this.urlMap = urlMap;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public TargetHttpProxyOptions build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"TargetHttpProxyOptions name cannot be null");
            Preconditions.checkNotNull((Object)this.urlMap, (Object)"TargetHttpProxyOptions name cannot be null");
            return TargetHttpProxyOptions.create(this.name, this.description, this.urlMap);
        }
    }
}

