/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Iterator;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.NewTargetInstance;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.TargetInstance;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/targetInstances")
@Consumes(value={"application/json"})
public interface TargetInstanceApi {
    @Named(value="TargetInstances:get")
    @GET
    @Path(value="/{targetInstance}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public TargetInstance get(@PathParam(value="targetInstance") String var1);

    @Named(value="TargetInstances:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) NewTargetInstance var1);

    @Named(value="TargetInstances:delete")
    @DELETE
    @Path(value="/{targetInstance}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="targetInstance") String var1);

    @Named(value="TargetInstances:list")
    @GET
    public ListPage<TargetInstance> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="TargetInstances:list")
    @GET
    @Transform(value=TargetInstancePages.class)
    public Iterator<ListPage<TargetInstance>> list();

    @Named(value="TargetInstances:list")
    @GET
    @Transform(value=TargetInstancePages.class)
    public Iterator<ListPage<TargetInstance>> list(ListOptions var1);

    public static final class TargetInstancePages
    extends BaseCallerArg0ToIteratorOfListPage<TargetInstance, TargetInstancePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        TargetInstancePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<TargetInstance>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<TargetInstance>>(){

                public ListPage<TargetInstance> apply(String pageToken) {
                    return api.targetInstancesInZone(zoneName).listPage(pageToken, options);
                }
            };
        }
    }
}

