/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AutoValue_Network;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Network {
    public abstract String id();

    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String rangeIPv4();

    @Nullable
    public abstract String gatewayIPv4();

    public abstract boolean autoCreateSubnetworks();

    public abstract List<URI> subnetworks();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "IPv4Range", "gatewayIPv4", "autoCreateSubnetworks", "subnetworks"})
    public static Network create(String id, Date creationTimestamp, URI selfLink, String name, String description, String rangeIPv4, String gatewayIPv4, boolean autoCreateSubnetworks, List<URI> subnetworks) {
        return new AutoValue_Network(id, creationTimestamp, selfLink, name, description, rangeIPv4, gatewayIPv4, autoCreateSubnetworks, (List<URI>)(subnetworks == null ? ImmutableList.of() : ImmutableList.copyOf(subnetworks)));
    }

    Network() {
    }

    public NetworkType type() {
        return !Strings.isNullOrEmpty((String)this.rangeIPv4()) ? NetworkType.LegacyNetwork : (this.autoCreateSubnetworks() ? NetworkType.AutoSubnetwork : NetworkType.CustomNetwork);
    }

    public static enum NetworkType {
        LegacyNetwork,
        AutoSubnetwork,
        CustomNetwork;

    }
}

