/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jclouds.googlecomputeengine.domain.AutoValue_Metadata;
import org.jclouds.googlecomputeengine.domain.KeyValuePair;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Metadata
implements Cloneable {
    @Nullable
    public abstract String fingerprint();

    public Metadata put(String key, String value) {
        this.remove(key);
        this.items().add(KeyValuePair.create(key, value));
        return this;
    }

    public Metadata putAll(Map<String, String> input) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Metadata remove(String key) {
        int length = this.items().size();
        for (int i = 0; i < length; ++i) {
            if (!this.items().get(i).key().equals(key)) continue;
            this.items().remove(i);
            return this;
        }
        return this;
    }

    public Map<String, String> asMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ArrayList<KeyValuePair> items = this.items();
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            KeyValuePair item = items.get(i);
            result.put(item.key(), item.value());
        }
        return result;
    }

    @Nullable
    public String get(String key) {
        ArrayList<KeyValuePair> items = this.items();
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            KeyValuePair item = items.get(i);
            if (!item.key().equals(key)) continue;
            return item.value();
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public int size() {
        return this.items().size();
    }

    abstract ArrayList<KeyValuePair> items();

    public static Metadata create() {
        return Metadata.create(null, null);
    }

    public static Metadata create(String fingerprint) {
        return Metadata.create(fingerprint, null);
    }

    @SerializedNames(value={"fingerprint", "items"})
    static Metadata create(String fingerprint, ArrayList<KeyValuePair> items) {
        return new AutoValue_Metadata(fingerprint, items != null ? items : new ArrayList());
    }

    Metadata() {
    }

    public Metadata clone() {
        return Metadata.create(this.fingerprint(), new ArrayList<KeyValuePair>(this.items()));
    }
}

