/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.Atomics;
import com.google.gson.GsonBuilder;
import com.google.inject.TypeLiteral;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jclouds.crypto.Crypto;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class ResetWindowsPassword
implements Function<Map<String, ?>, String> {
    private static final long EXPIRE_DURATION = 600000L;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GoogleComputeEngineApi api;
    private final Crypto crypto;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final Json json;
    private static final Predicate<Map<String, Object>> HasEncryptedPassword = new Predicate<Map<String, Object>>(){

        public boolean apply(Map<String, Object> input) {
            return input.containsKey("encryptedPassword");
        }
    };
    private static final Function<Map<String, Object>, String> ExtractEncryptedPassword = new Function<Map<String, Object>, String>(){

        public String apply(Map<String, Object> input) {
            return (String)input.get("encryptedPassword");
        }
    };

    @Inject
    protected ResetWindowsPassword(GoogleComputeEngineApi api, Crypto crypto, Predicate<AtomicReference<Operation>> operationDone, Json json) {
        this.api = api;
        this.crypto = crypto;
        this.operationDone = operationDone;
        this.json = json;
    }

    public String apply(Map<String, ?> params) {
        String zone = (String)params.get("zone");
        AtomicReference instance = (AtomicReference)params.get("instance");
        String userName = (String)params.get("userName");
        String email = (String)params.get("email");
        KeyPair keys = this.crypto.rsaKeyPairGenerator().genKeyPair();
        this.logger.debug("Generating windows key for instance %s, by updating metadata", new Object[]{((Instance)instance.get()).name()});
        final InstanceApi instanceApi = this.api.instancesInZone(zone);
        Metadata metadata = ((Instance)instance.get()).metadata();
        try {
            metadata.put("windows-keys", new GsonBuilder().disableHtmlEscaping().create().toJson(this.extractKeyMetadata(keys, userName, email)));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            Throwables.propagate((Throwable)e);
        }
        AtomicReference operation = Atomics.newReference((Object)instanceApi.setMetadata(((Instance)instance.get()).name(), metadata));
        this.operationDone.apply((Object)operation);
        if (((Operation)operation.get()).httpErrorStatusCode() != null) {
            this.logger.warn("Generating windows key for %s failed. Http Error Code: %d HttpError: %s", new Object[]{((Operation)operation.get()).targetId(), ((Operation)operation.get()).httpErrorStatusCode(), ((Operation)operation.get()).httpErrorMessage()});
        }
        try {
            final AtomicReference encryptedPassword = Atomics.newReference();
            boolean passwordRetrieved = Predicates2.retry((Predicate)new Predicate<Instance>(){

                public boolean apply(Instance instance) {
                    String serialPortContents = instanceApi.getSerialPortOutput(instance.name(), 4).contents();
                    List contentEntries = Splitter.on((char)'\n').splitToList((CharSequence)serialPortContents);
                    Optional retrievedPassword = Iterables.tryFind((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)contentEntries, ResetWindowsPassword.deserializeSerialOutput(ResetWindowsPassword.this.json)), (Predicate)Predicates.notNull()), HasEncryptedPassword).transform(ExtractEncryptedPassword);
                    if (retrievedPassword.isPresent()) {
                        encryptedPassword.set((String)retrievedPassword.get());
                    }
                    return retrievedPassword.isPresent();
                }
            }, (long)600L, (long)30L, (TimeUnit)TimeUnit.SECONDS).apply((Object)((Instance)instance.get()));
            if (passwordRetrieved) {
                return this.decryptPassword((String)encryptedPassword.get(), keys);
            }
            throw new IllegalStateException("Did not find the encrypted password in the serial port output");
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Function<String, Map<String, Object>> deserializeSerialOutput(final Json json) {
        return new Function<String, Map<String, Object>>(){

            public Map<String, Object> apply(String input) {
                try {
                    return (Map)json.fromJson(input, new TypeLiteral<Map<String, Object>>(){}.getType());
                }
                catch (Exception ex) {
                    return null;
                }
            }
        };
    }

    protected String decryptPassword(String message, KeyPair keys) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        try {
            cipher = this.crypto.cipher("RSA/NONE/OAEPPadding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Problem finding cypher. Try adding bouncycastle dependency.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Problem finding cypher. Try adding bouncycastle dependency.", e);
        }
        cipher.init(2, keys.getPrivate());
        byte[] rawMessage = BaseEncoding.base64().decode((CharSequence)message);
        byte[] decryptedText = cipher.doFinal(rawMessage);
        return new String(decryptedText, Charset.forName("UTF-8"));
    }

    protected Map<String, String> extractKeyMetadata(KeyPair pair, String userName, String email) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = this.crypto.rsaKeyFactory();
        RSAPublicKeySpec pubSpec = factory.getKeySpec(pair.getPublic(), RSAPublicKeySpec.class);
        BigInteger modulus = pubSpec.getModulus();
        BigInteger exponent = pubSpec.getPublicExponent();
        byte[] modulusArr = Arrays.copyOfRange(modulus.toByteArray(), 1, modulus.toByteArray().length);
        String modulusString = BaseEncoding.base64().encode(modulusArr).replaceAll("\n", "");
        String exponentString = BaseEncoding.base64().encode(exponent.toByteArray()).replaceAll("\n", "");
        Date expireDate = new Date(System.currentTimeMillis() + 600000L);
        SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        rfc3339Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String expireString = rfc3339Format.format(expireDate);
        return ImmutableMap.builder().put((Object)"modulus", (Object)modulusString).put((Object)"exponent", (Object)exponentString).put((Object)"expireOn", (Object)expireString).put((Object)"userName", (Object)userName).put((Object)"email", (Object)email).build();
    }
}

