/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.binders;

import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import org.jclouds.googlecomputeengine.domain.ForwardingRule;
import org.jclouds.googlecomputeengine.options.ForwardingRuleCreationOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;

public class ForwardingRuleCreationBinder
extends BindToJsonPayload {
    @Inject
    ForwardingRuleCreationBinder(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ForwardingRuleCreationOptions options = (ForwardingRuleCreationOptions)postParams.get("options");
        String name = postParams.get("name").toString();
        ForwardingRuleCreationBinderHelper forwardingRuleCreationBinderHelper = new ForwardingRuleCreationBinderHelper(name, options);
        return (R)super.bindToRequest(request, (Object)forwardingRuleCreationBinderHelper);
    }

    private static class ForwardingRuleCreationBinderHelper {
        private String name;
        private String description;
        private String ipAddress;
        private ForwardingRule.IPProtocol ipProtocol;
        private String portRange;
        private URI target;

        private ForwardingRuleCreationBinderHelper(String name, ForwardingRuleCreationOptions forwardingRuleCreationOptions) {
            this.name = name;
            this.description = forwardingRuleCreationOptions.description();
            this.ipAddress = forwardingRuleCreationOptions.ipAddress();
            this.ipProtocol = forwardingRuleCreationOptions.ipProtocol();
            this.portRange = forwardingRuleCreationOptions.portRange();
            this.target = forwardingRuleCreationOptions.target();
        }
    }
}

