/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class GoGridDefaultLocationSupplier
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locations;
    private final String defaultDC;

    @Inject
    GoGridDefaultLocationSupplier(@Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.template") String template) {
        this.locations = locations;
        Map map = Splitter.on((char)',').trimResults().withKeyValueSeparator("=").split((CharSequence)template);
        this.defaultDC = (String)Preconditions.checkNotNull((Object)((String)map.get("locationId")), (String)"locationId not in % value: %s", (Object)"jclouds.template", (Object)template);
    }

    public Location get() {
        return (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.getId().equals(GoGridDefaultLocationSupplier.this.defaultDC);
            }
        });
    }
}

