/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;
    private final Long timeStamp;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(@Provider Supplier<Credentials> creds, @TimeStamp Long timeStamp, HttpUtils utils) {
        this.creds = creds;
        this.timeStamp = timeStamp;
        this.utils = utils;
    }

    public HttpRequest filter(HttpRequest request) {
        String toSign = this.createStringToSign();
        String signatureMd5 = this.getMd5For(toSign);
        request = request.toBuilder().replaceQueryParams((Map)ImmutableMap.of((Object)"sig", (Object)signatureMd5, (Object)"api_key", (Object)((Credentials)this.creds.get()).identity)).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    private String createStringToSign() {
        return String.format("%s%s%s", ((Credentials)this.creds.get()).identity, ((Credentials)this.creds.get()).credential, this.timeStamp);
    }

    private String getMd5For(String stringToHash) {
        return BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString((CharSequence)stringToHash, Charsets.UTF_8).asBytes());
    }
}

