/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.features;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.gogrid.functions.ParseImageFromJsonResponse;
import org.jclouds.gogrid.functions.ParseImageListFromJsonResponse;
import org.jclouds.gogrid.functions.ParseOptionsFromJsonResponse;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.SaveImageOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@QueryParams(keys={"v"}, values={"{jclouds.api-version}"})
public interface GridImageApi {
    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/list")
    public Set<ServerImage> getImageList(GetImageListOptions ... var1);

    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/get")
    public Set<ServerImage> getImagesById(Long ... var1);

    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/get")
    public Set<ServerImage> getImagesByName(String ... var1);

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/edit")
    public ServerImage editImageDescription(@QueryParam(value="image") String var1, @QueryParam(value="description") String var2);

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/edit")
    public ServerImage editImageFriendlyName(@QueryParam(value="image") String var1, @QueryParam(value="friendlyName") String var2);

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"datacenter"})
    public Set<Option> getDatacenters();

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/delete")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ServerImage deleteById(@QueryParam(value="id") long var1);

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/save")
    public ServerImage saveImageFromServer(@QueryParam(value="friendlyName") String var1, @QueryParam(value="server") String var2, SaveImageOptions ... var3);
}

