/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdsToQueryParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof Long[]) {
            Object[] names = (Long[])input;
            return (R)request.toBuilder().replaceQueryParam("id", Iterables.transform((Iterable)ImmutableList.copyOf((Object[])names), (Function)Functions.toStringFunction())).build();
        }
        if (input instanceof long[]) {
            long[] names = (long[])input;
            return (R)request.toBuilder().replaceQueryParam("id", Iterables.transform((Iterable)Longs.asList((long[])names), (Function)Functions.toStringFunction())).build();
        }
        throw new IllegalArgumentException("this binder is only valid for Long[] arguments: " + String.valueOf(input.getClass()));
    }
}

