/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.handlers;

import com.google.common.base.Optional;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.RateLimitRetryHandler;

@Singleton
public class DigitalOcean2RateLimitRetryHandler
extends RateLimitRetryHandler {
    protected Optional<Long> millisToNextAvailableRequest(HttpCommand command, HttpResponse response) {
        String epochForNextAvailableRequest = response.getFirstHeaderOrNull("RateLimit-Reset");
        if (epochForNextAvailableRequest == null) {
            return Optional.absent();
        }
        return Optional.of((Object)DigitalOcean2RateLimitRetryHandler.millisUntilNextAvailableRequest(Long.parseLong(epochForNextAvailableRequest)));
    }

    public static long millisUntilNextAvailableRequest(long epochForNextAvailableRequest) {
        return epochForNextAvailableRequest * 1000L - System.currentTimeMillis();
    }
}

