/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.handlers;

import jakarta.inject.Singleton;
import org.jclouds.digitalocean2.exceptions.DigitalOcean2RateLimitExceededException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class DigitalOcean2ErrorHandler
implements HttpErrorHandler {
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        Object exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                break;
            }
            case 401: 
            case 403: {
                if (message.contains("droplet limit")) {
                    exception = new InsufficientResourcesException(message, (Throwable)exception);
                    break;
                }
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case 409: {
                exception = new IllegalStateException(message, (Throwable)exception);
                break;
            }
            case 429: {
                exception = new DigitalOcean2RateLimitExceededException(response, (Throwable)exception);
            }
        }
        command.setException((Exception)exception);
    }
}

