/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.exceptions;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.jclouds.digitalocean2.handlers.DigitalOcean2RateLimitRetryHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RateLimitExceededException;

@Beta
public class DigitalOcean2RateLimitExceededException
extends RateLimitExceededException {
    private static final long serialVersionUID = 1L;
    private static final String RATE_LIMIT_HEADER_PREFIX = "RateLimit-";
    private Integer totalRequestsPerHour;
    private Integer remainingRequests;
    private Long timeToNextAvailableRequest;

    public DigitalOcean2RateLimitExceededException(HttpResponse response) {
        super(response.getStatusLine() + "\n" + String.valueOf(DigitalOcean2RateLimitExceededException.rateLimitHeaders(response)));
        this.parseRateLimitInfo(response);
    }

    public DigitalOcean2RateLimitExceededException(HttpResponse response, Throwable cause) {
        super(response.getStatusLine() + "\n" + String.valueOf(DigitalOcean2RateLimitExceededException.rateLimitHeaders(response)), cause);
        this.parseRateLimitInfo(response);
    }

    public Integer totalRequestsPerHour() {
        return this.totalRequestsPerHour;
    }

    public Integer remainingRequests() {
        return this.remainingRequests;
    }

    public Long timeToNextAvailableRequest() {
        return this.timeToNextAvailableRequest;
    }

    private void parseRateLimitInfo(HttpResponse response) {
        String limit = response.getFirstHeaderOrNull("RateLimit-Limit");
        String remaining = response.getFirstHeaderOrNull("RateLimit-Remaining");
        String reset = response.getFirstHeaderOrNull("RateLimit-Reset");
        this.totalRequestsPerHour = limit == null ? null : Integer.valueOf(limit);
        this.remainingRequests = remaining == null ? null : Integer.valueOf(remaining);
        this.timeToNextAvailableRequest = reset == null ? null : Long.valueOf(DigitalOcean2RateLimitRetryHandler.millisUntilNextAvailableRequest(Long.parseLong(reset)));
    }

    private static Multimap<String, String> rateLimitHeaders(HttpResponse response) {
        return Multimaps.filterKeys((Multimap)response.getHeaders(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(DigitalOcean2RateLimitExceededException.RATE_LIMIT_HEADER_PREFIX);
            }
        });
    }
}

