/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.digitalocean2.domain.AutoValue_Image;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Image {
    public abstract int id();

    public abstract String name();

    public abstract String type();

    public abstract String distribution();

    @Nullable
    public abstract String slug();

    public abstract boolean isPublic();

    public abstract List<String> regions();

    public abstract Date createdAt();

    public abstract float minDiskSize();

    public abstract float sizeGBs();

    @SerializedNames(value={"id", "name", "type", "distribution", "slug", "public", "regions", "created_at", "min_disk_size", "size_gigabytes"})
    public static Image create(int id, String name, String type, String distribution, String slug, boolean isPublic, List<String> regions, Date createdAt, float minDiskSize, float sizeGBs) {
        return new AutoValue_Image(id, name, type, distribution, slug, isPublic, (List<String>)ImmutableList.copyOf(regions), createdAt, minDiskSize, sizeGBs);
    }

    Image() {
    }
}

