/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import java.util.List;
import org.jclouds.digitalocean2.domain.Size;

final class AutoValue_Size
extends Size {
    private final String slug;
    private final boolean available;
    private final float transfer;
    private final float priceMonthly;
    private final float priceHourly;
    private final int memory;
    private final int vcpus;
    private final int disk;
    private final List<String> regions;

    AutoValue_Size(String slug, boolean available, float transfer, float priceMonthly, float priceHourly, int memory, int vcpus, int disk, List<String> regions) {
        if (slug == null) {
            throw new NullPointerException("Null slug");
        }
        this.slug = slug;
        this.available = available;
        this.transfer = transfer;
        this.priceMonthly = priceMonthly;
        this.priceHourly = priceHourly;
        this.memory = memory;
        this.vcpus = vcpus;
        this.disk = disk;
        if (regions == null) {
            throw new NullPointerException("Null regions");
        }
        this.regions = regions;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public float transfer() {
        return this.transfer;
    }

    @Override
    public float priceMonthly() {
        return this.priceMonthly;
    }

    @Override
    public float priceHourly() {
        return this.priceHourly;
    }

    @Override
    public int memory() {
        return this.memory;
    }

    @Override
    public int vcpus() {
        return this.vcpus;
    }

    @Override
    public int disk() {
        return this.disk;
    }

    @Override
    public List<String> regions() {
        return this.regions;
    }

    public String toString() {
        return "Size{slug=" + this.slug + ", available=" + this.available + ", transfer=" + this.transfer + ", priceMonthly=" + this.priceMonthly + ", priceHourly=" + this.priceHourly + ", memory=" + this.memory + ", vcpus=" + this.vcpus + ", disk=" + this.disk + ", regions=" + String.valueOf(this.regions) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Size) {
            Size that = (Size)o;
            return this.slug.equals(that.slug()) && this.available == that.available() && Float.floatToIntBits(this.transfer) == Float.floatToIntBits(that.transfer()) && Float.floatToIntBits(this.priceMonthly) == Float.floatToIntBits(that.priceMonthly()) && Float.floatToIntBits(this.priceHourly) == Float.floatToIntBits(that.priceHourly()) && this.memory == that.memory() && this.vcpus == that.vcpus() && this.disk == that.disk() && this.regions.equals(that.regions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.slug.hashCode();
        h$ *= 1000003;
        h$ ^= this.available ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.transfer);
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.priceMonthly);
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.priceHourly);
        h$ *= 1000003;
        h$ ^= this.memory;
        h$ *= 1000003;
        h$ ^= this.vcpus;
        h$ *= 1000003;
        h$ ^= this.disk;
        h$ *= 1000003;
        return h$ ^= this.regions.hashCode();
    }
}

