/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Networks;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class DropletToNodeMetadata
implements Function<Droplet, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>> images;
    private final Supplier<Map<String, ? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Droplet.Status, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention groupNamingConvention;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DropletToNodeMetadata(Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>> images, Supplier<Map<String, ? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, Function<Droplet.Status, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory groupNamingConvention, Map<String, Credentials> credentialStore) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images cannot be null");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares cannot be null");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations cannot be null");
        this.toPortableStatus = (Function)Preconditions.checkNotNull(toPortableStatus, (Object)"toPortableStatus cannot be null");
        this.groupNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)groupNamingConvention, (Object)"groupNamingConvention cannot be null")).createWithoutPrefix();
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore cannot be null");
    }

    public NodeMetadata apply(Droplet input) {
        Credentials credentials;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(String.valueOf(input.id()));
        builder.name(input.name());
        builder.hostname(input.name());
        builder.group(this.groupNamingConvention.extractGroup(input.name()));
        builder.hardware(this.getHardware(input.sizeSlug()));
        builder.location(this.getLocation(input.region()));
        Optional<? extends org.jclouds.compute.domain.Image> image = this.findImage(input.image(), input.region().slug());
        if (image.isPresent()) {
            builder.imageId(((org.jclouds.compute.domain.Image)image.get()).getId());
            builder.operatingSystem(((org.jclouds.compute.domain.Image)image.get()).getOperatingSystem());
        } else {
            this.logger.info(">> image with id %s for droplet %s was not found. This might be because the image that was used to create the droplet has a new id.", new Object[]{input.image().id(), input.id()});
        }
        builder.status((NodeMetadata.Status)this.toPortableStatus.apply((Object)input.status()));
        builder.backendStatus(input.status().name());
        if (!input.getPublicAddresses().isEmpty()) {
            builder.publicAddresses((Iterable)FluentIterable.from(input.getPublicAddresses()).transform((Function)new Function<Networks.Address, String>(){

                public String apply(Networks.Address input) {
                    return input.ip();
                }
            }));
        }
        if (!input.getPrivateAddresses().isEmpty()) {
            builder.privateAddresses((Iterable)FluentIterable.from(input.getPrivateAddresses()).transform((Function)new Function<Networks.Address, String>(){

                public String apply(Networks.Address input) {
                    return input.ip();
                }
            }));
        }
        if ((credentials = this.credentialStore.get("node#" + input.id())) instanceof LoginCredentials) {
            builder.credentials((LoginCredentials)LoginCredentials.class.cast(credentials));
        }
        return builder.build();
    }

    protected Optional<? extends org.jclouds.compute.domain.Image> findImage(Image image, String region) {
        return Optional.fromNullable((Object)((org.jclouds.compute.domain.Image)((Map)this.images.get()).get(ImageInRegion.encodeId(ImageInRegion.create(image, region)))));
    }

    protected Hardware getHardware(final String slug) {
        return (Hardware)Iterables.find(((Map)this.hardwares.get()).values(), (Predicate)new Predicate<Hardware>(){

            public boolean apply(Hardware input) {
                return input.getId().equals(slug);
            }
        });
    }

    protected Location getLocation(final Region region) {
        return (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

            public boolean apply(Location location) {
                return region != null && region.slug().equals(location.getId());
            }
        }, null);
    }
}

